/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.spi.blocking;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.spi.blocking.BlockingResource;
import com.hazelcast.cp.internal.datastructures.spi.blocking.WaitKey;
import com.hazelcast.cp.internal.util.Tuple2;
import com.hazelcast.cp.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ResourceRegistry<W extends WaitKey, R extends BlockingResource<W>>
implements DataSerializable {
    protected CPGroupId groupId;
    protected final Map<String, R> resources = new ConcurrentHashMap<String, R>();
    protected final Set<String> destroyedNames = new HashSet<String>();
    protected final ConcurrentMap<Tuple2<String, UUID>, Tuple2<Long, Long>> waitTimeouts = new ConcurrentHashMap<Tuple2<String, UUID>, Tuple2<Long, Long>>();

    public ResourceRegistry() {
    }

    protected ResourceRegistry(CPGroupId groupId) {
        this.groupId = groupId;
    }

    protected abstract R createNewResource(CPGroupId var1, String var2);

    protected abstract ResourceRegistry<W, R> cloneForSnapshot();

    public final R getResourceOrNull(String name) {
        this.checkNotDestroyed(name);
        return (R)((BlockingResource)this.resources.get(name));
    }

    protected final R getOrInitResource(String name) {
        this.checkNotDestroyed(name);
        BlockingResource<Object> resource = (BlockingResource)this.resources.get(name);
        if (resource == null) {
            resource = this.createNewResource(this.groupId, name);
            this.resources.put(name, resource);
        }
        return (R)resource;
    }

    private void checkNotDestroyed(String name) {
        Preconditions.checkNotNull(name);
        if (this.destroyedNames.contains(name)) {
            throw new DistributedObjectDestroyedException("Resource[" + name + "] is already destroyed!");
        }
    }

    protected final void addWaitKey(String name, UUID invocationUid, long timeoutMs) {
        if (timeoutMs > 0L) {
            this.waitTimeouts.putIfAbsent(Tuple2.of(name, invocationUid), Tuple2.of(timeoutMs, Clock.currentTimeMillis() + timeoutMs));
        }
    }

    protected final void removeWaitKey(String name, W key) {
        this.removeWaitKey(name, key.invocationUid());
    }

    protected final void removeWaitKey(String name, UUID invocationUid) {
        this.waitTimeouts.remove(Tuple2.of(name, invocationUid));
    }

    final void expireWaitKey(String name, UUID invocationUid, List<Long> commitIndices) {
        this.removeWaitKey(name, invocationUid);
        R resource = this.getResourceOrNull(name);
        if (resource != null) {
            ((BlockingResource)resource).expireWaitKey(invocationUid, commitIndices);
        }
    }

    final Collection<Tuple2<String, UUID>> getWaitKeysToExpire(long now) {
        ArrayList<Tuple2<String, UUID>> expired = new ArrayList<Tuple2<String, UUID>>();
        for (Map.Entry e : this.waitTimeouts.entrySet()) {
            long deadline = (Long)((Tuple2)e.getValue()).element2;
            if (deadline > now) continue;
            expired.add((Tuple2<String, UUID>)e.getKey());
        }
        return expired;
    }

    final Map<Tuple2<String, UUID>, Long> overwriteWaitTimeouts(Map<Tuple2<String, UUID>, Tuple2<Long, Long>> existingWaitTimeouts) {
        for (Map.Entry<Tuple2<String, UUID>, Tuple2<Long, Long>> e : existingWaitTimeouts.entrySet()) {
            this.waitTimeouts.put(e.getKey(), e.getValue());
        }
        HashMap<Tuple2<String, UUID>, Long> newKeys = new HashMap<Tuple2<String, UUID>, Long>();
        for (Map.Entry e : this.waitTimeouts.entrySet()) {
            Tuple2 key = (Tuple2)e.getKey();
            if (existingWaitTimeouts.containsKey(key)) continue;
            Long timeout = (Long)((Tuple2)e.getValue()).element1;
            newKeys.put(key, timeout);
        }
        return newKeys;
    }

    final void closeSession(long sessionId, List<Long> expiredWaitKeys, Map<Long, Object> result) {
        for (BlockingResource resource : this.resources.values()) {
            resource.closeSession(sessionId, expiredWaitKeys, result);
        }
    }

    final Collection<Long> getAttachedSessions() {
        HashSet<Long> sessions = new HashSet<Long>();
        for (BlockingResource res : this.resources.values()) {
            res.collectAttachedSessions(sessions);
        }
        return sessions;
    }

    final Collection<Long> destroyResource(String name) {
        this.destroyedNames.add(name);
        BlockingResource resource = (BlockingResource)this.resources.remove(name);
        if (resource == null) {
            return null;
        }
        Collection waitKeys = resource.getAllWaitKeys();
        ArrayList<Long> indices = new ArrayList<Long>(waitKeys.size());
        for (WaitKey key : waitKeys) {
            indices.add(key.commitIndex());
            this.waitTimeouts.remove(Tuple2.of(name, key.invocationUid()));
        }
        return indices;
    }

    public final CPGroupId getGroupId() {
        return this.groupId;
    }

    public final Map<Tuple2<String, UUID>, Tuple2<Long, Long>> getWaitTimeouts() {
        return Collections.unmodifiableMap(this.waitTimeouts);
    }

    public final Collection<Long> destroy() {
        this.destroyedNames.addAll(this.resources.keySet());
        ArrayList<Long> indices = new ArrayList<Long>();
        for (BlockingResource raftLock : this.resources.values()) {
            for (WaitKey key : raftLock.getAllWaitKeys()) {
                indices.add(key.commitIndex());
            }
        }
        this.resources.clear();
        this.waitTimeouts.clear();
        return indices;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.groupId);
        out.writeInt(this.resources.size());
        for (Map.Entry<String, R> entry : this.resources.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.destroyedNames.size());
        for (String string : this.destroyedNames) {
            out.writeUTF(string);
        }
        out.writeInt(this.waitTimeouts.size());
        for (Map.Entry entry : this.waitTimeouts.entrySet()) {
            Tuple2 t = (Tuple2)entry.getKey();
            out.writeUTF((String)t.element1);
            UUIDSerializationUtil.writeUUID(out, (UUID)t.element2);
            out.writeLong((Long)((Tuple2)entry.getValue()).element1);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        String name;
        int i;
        this.groupId = (CPGroupId)in.readObject();
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            name = in.readUTF();
            BlockingResource res = (BlockingResource)in.readObject();
            this.resources.put(name, res);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            name = in.readUTF();
            this.destroyedNames.add(name);
        }
        long now = Clock.currentTimeMillis();
        count = in.readInt();
        for (int i2 = 0; i2 < count; ++i2) {
            String name2 = in.readUTF();
            UUID invocationUid = UUIDSerializationUtil.readUUID(in);
            long timeout = in.readLong();
            this.waitTimeouts.put(Tuple2.of(name2, invocationUid), Tuple2.of(timeout, now + timeout));
        }
    }

    public String toString() {
        return "ResourceRegistry{groupId=" + this.groupId + ", resources=" + this.resources + ", destroyedNames=" + this.destroyedNames + ", waitTimeouts=" + this.waitTimeouts + '}';
    }
}

