/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.spi.blocking;

import com.hazelcast.cp.internal.datastructures.RaftDataServiceDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.spi.blocking.WaitKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class WaitKeyContainer<W extends WaitKey>
implements IdentifiedDataSerializable {
    private W key;
    private List<W> retries;

    public WaitKeyContainer() {
    }

    WaitKeyContainer(W key) {
        this.key = key;
    }

    public W key() {
        return this.key;
    }

    public List<W> retries() {
        return this.retries != null ? this.retries : Collections.emptyList();
    }

    public List<W> keyAndRetries() {
        if (this.retryCount() == 0) {
            return Collections.singletonList(this.key);
        }
        ArrayList<W> all = new ArrayList<W>(1 + this.retryCount());
        all.add(this.key);
        all.addAll(this.retries());
        return all;
    }

    public int retryCount() {
        return this.retries().size();
    }

    public long sessionId() {
        return this.key.sessionId();
    }

    public UUID invocationUid() {
        return this.key.invocationUid();
    }

    void addRetry(W retry) {
        Preconditions.checkTrue(this.sessionId() == this.key.sessionId(), this.key + " and its retry: " + retry + " has different session ids!");
        Preconditions.checkTrue(this.key.invocationUid().equals(retry.invocationUid()), this.key + " and its retry: " + retry + " has different invocation uids!");
        if (this.retries == null) {
            this.retries = new ArrayList<W>(1);
        }
        this.retries.add(retry);
    }

    @Override
    public int getFactoryId() {
        return RaftDataServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.key);
        int retryCount = this.retries != null ? this.retries.size() : 0;
        out.writeInt(retryCount);
        for (int i = 0; i < retryCount; ++i) {
            out.writeObject(this.retries.get(i));
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = (WaitKey)in.readObject();
        int retryCount = in.readInt();
        if (retryCount > 0) {
            this.retries = new ArrayList<W>(retryCount);
            for (int i = 0; i < retryCount; ++i) {
                WaitKey retry = (WaitKey)in.readObject();
                this.retries.add(retry);
            }
        }
    }

    public String toString() {
        return "WaitKeyContainer{key=" + this.key + ", retries=" + this.retries + '}';
    }
}

