/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.tcp.MemberProtocolEncoder;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;

public class SingleProtocolDecoder
extends InboundHandler<ByteBuffer, Void> {
    private final ProtocolType supportedProtocol;
    private final InboundHandler[] inboundHandlers;
    private final MemberProtocolEncoder encoder;

    SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler next) {
        this(supportedProtocol, new InboundHandler[]{next}, null);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler[] next, MemberProtocolEncoder encoder) {
        this.supportedProtocol = supportedProtocol;
        this.inboundHandlers = next;
        this.encoder = encoder;
    }

    @Override
    public void handlerAdded() {
        this.initSrcBuffer(3);
    }

    @Override
    public HandlerStatus onRead() {
        ((ByteBuffer)this.src).flip();
        try {
            if (((ByteBuffer)this.src).remaining() < 3) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            String protocol = this.loadProtocol();
            if (!protocol.equals(this.supportedProtocol.getDescriptor())) {
                throw new IllegalStateException("Unsupported protocol exchange detected, expected protocol: " + this.supportedProtocol.name());
            }
            this.channel.inboundPipeline().replace(this, this.inboundHandlers);
            if (this.shouldSignalProtocolLoaded()) {
                this.encoder.signalProtocolLoaded();
            }
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }

    private String loadProtocol() {
        byte[] protocolBytes = new byte[3];
        ((ByteBuffer)this.src).get(protocolBytes);
        return StringUtil.bytesToString(protocolBytes);
    }

    private boolean shouldSignalProtocolLoaded() {
        return !this.channel.isClientMode() && this.encoder != null;
    }
}

