/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.monitor.impl.IndexOperationStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.query.impl.DuplicateDetectingMultiResult;
import com.hazelcast.query.impl.FastMultiResultSet;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.query.impl.getters.MultiResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BaseIndexStore
implements IndexStore {
    static final float LOAD_FACTOR = 0.75f;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final CopyFunctor<Data, QueryableEntry> resultCopyFunctor;
    private boolean multiResultHasToDetectDuplicates;

    BaseIndexStore(IndexCopyBehavior copyOn) {
        this.resultCopyFunctor = copyOn == IndexCopyBehavior.COPY_ON_WRITE || copyOn == IndexCopyBehavior.NEVER ? new PassThroughFunctor() : new CopyInputFunctor();
    }

    abstract Object insertInternal(Comparable var1, QueryableEntry var2);

    abstract Object removeInternal(Comparable var1, Data var2);

    void takeWriteLock() {
        this.writeLock.lock();
    }

    void releaseWriteLock() {
        this.writeLock.unlock();
    }

    void takeReadLock() {
        this.readLock.lock();
    }

    void releaseReadLock() {
        this.readLock.unlock();
    }

    final MultiResultSet createMultiResultSet() {
        return this.multiResultHasToDetectDuplicates ? new DuplicateDetectingMultiResult() : new FastMultiResultSet();
    }

    final void copyToMultiResultSet(MultiResultSet resultSet, Map<Data, QueryableEntry> records) {
        resultSet.addResultSet(this.resultCopyFunctor.invoke(records));
    }

    final Set<QueryableEntry> toSingleResultSet(Map<Data, QueryableEntry> records) {
        return new SingleResultSet(this.resultCopyFunctor.invoke(records));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insert(Object value, QueryableEntry record, IndexOperationStats operationStats) {
        this.takeWriteLock();
        try {
            this.unwrapAndInsertToIndex(value, record, operationStats);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(Object oldValue, Object newValue, QueryableEntry entry, IndexOperationStats operationStats) {
        this.takeWriteLock();
        try {
            Data indexKey = entry.getKeyData();
            this.unwrapAndRemoveFromIndex(oldValue, indexKey, operationStats);
            this.unwrapAndInsertToIndex(newValue, entry, operationStats);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(Object value, Data indexKey, IndexOperationStats operationStats) {
        this.takeWriteLock();
        try {
            this.unwrapAndRemoveFromIndex(value, indexKey, operationStats);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void destroy() {
    }

    private void unwrapAndInsertToIndex(Object newValue, QueryableEntry record, IndexOperationStats operationStats) {
        if (newValue instanceof MultiResult) {
            this.multiResultHasToDetectDuplicates = true;
            List results = ((MultiResult)newValue).getResults();
            for (Object o : results) {
                Comparable sanitizedValue = BaseIndexStore.sanitizeValue(o);
                Object oldValue = this.insertInternal(sanitizedValue, record);
                operationStats.onEntryAdded(oldValue, newValue);
            }
        } else {
            Comparable sanitizedValue = BaseIndexStore.sanitizeValue(newValue);
            Object oldValue = this.insertInternal(sanitizedValue, record);
            operationStats.onEntryAdded(oldValue, newValue);
        }
    }

    private void unwrapAndRemoveFromIndex(Object oldValue, Data indexKey, IndexOperationStats operationStats) {
        if (oldValue instanceof MultiResult) {
            List results = ((MultiResult)oldValue).getResults();
            for (Object o : results) {
                Comparable sanitizedValue = BaseIndexStore.sanitizeValue(o);
                Object removedValue = this.removeInternal(sanitizedValue, indexKey);
                operationStats.onEntryRemoved(removedValue);
            }
        } else {
            Comparable sanitizedValue = BaseIndexStore.sanitizeValue(oldValue);
            Object removedValue = this.removeInternal(sanitizedValue, indexKey);
            operationStats.onEntryRemoved(removedValue);
        }
    }

    private static Comparable sanitizeValue(Object input) {
        if (input instanceof CompositeValue) {
            CompositeValue compositeValue = (CompositeValue)input;
            Comparable[] components = compositeValue.getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i] = BaseIndexStore.sanitizeScalar(components[i]);
            }
            return compositeValue;
        }
        return BaseIndexStore.sanitizeScalar(input);
    }

    private static Comparable sanitizeScalar(Object input) {
        if (input == null || input instanceof Comparable) {
            Comparable value = (Comparable)input;
            if (value == null) {
                value = AbstractIndex.NULL;
            } else if (value.getClass().isEnum()) {
                value = TypeConverters.ENUM_CONVERTER.convert(value);
            }
            return value;
        }
        throw new IllegalArgumentException("It is not allowed to use a type that is not Comparable: " + input.getClass());
    }

    private static class CopyInputFunctor
    implements CopyFunctor<Data, QueryableEntry> {
        private CopyInputFunctor() {
        }

        @Override
        public Map<Data, QueryableEntry> invoke(Map<Data, QueryableEntry> map) {
            if (map != null && !map.isEmpty()) {
                return new HashMap<Data, QueryableEntry>(map);
            }
            return map;
        }
    }

    private static class PassThroughFunctor
    implements CopyFunctor<Data, QueryableEntry> {
        private PassThroughFunctor() {
        }

        @Override
        public Map<Data, QueryableEntry> invoke(Map<Data, QueryableEntry> map) {
            return map;
        }
    }

    static interface IndexFunctor<A, B> {
        public Object invoke(A var1, B var2);
    }

    static interface CopyFunctor<A, B> {
        public Map<A, B> invoke(Map<A, B> var1);
    }
}

