/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.lock;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPFencedLockGetLockOwnershipCodec;
import com.hazelcast.client.impl.protocol.codec.CPFencedLockLockCodec;
import com.hazelcast.client.impl.protocol.codec.CPFencedLockTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.CPFencedLockUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.lock.RaftLockOwnershipState;
import com.hazelcast.cp.internal.datastructures.lock.proxy.AbstractRaftFencedLockProxy;
import com.hazelcast.cp.internal.session.AbstractProxySessionManager;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

class RaftFencedLockProxy
extends ClientProxy
implements FencedLock {
    private static final ClientMessageDecoder LOCK_RESPONSE_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPFencedLockLockCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder TRY_RESPONSE_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPFencedLockTryLockCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder UNLOCK_RESPONSE_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return CPFencedLockUnlockCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_LOCK_OWNERSHIP_STATE_RESPONSE_DECODER = new ClientMessageDecoder(){

        public RaftLockOwnershipState decodeClientMessage(ClientMessage clientMessage) {
            CPFencedLockGetLockOwnershipCodec.ResponseParameters params = CPFencedLockGetLockOwnershipCodec.decodeResponse(clientMessage);
            return new RaftLockOwnershipState(params.fence, params.lockCount, params.sessionId, params.threadId);
        }
    };
    private final FencedLockImpl lock;

    RaftFencedLockProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:lockService", proxyName, context);
        this.lock = new FencedLockImpl(this.getClient().getProxySessionManager(), groupId, proxyName, objectName);
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    @Override
    public long lockAndGetFence() {
        return this.lock.lockAndGetFence();
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public long tryLockAndGetFence() {
        return this.lock.tryLockAndGetFence();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        return this.lock.tryLock(time, unit);
    }

    @Override
    public long tryLockAndGetFence(long time, TimeUnit unit) {
        return this.lock.tryLockAndGetFence(time, unit);
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public long getFence() {
        return this.lock.getFence();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public boolean isLockedByCurrentThread() {
        return this.lock.isLockedByCurrentThread();
    }

    @Override
    public int getLockCount() {
        return this.lock.getLockCount();
    }

    @Override
    public CPGroupId getGroupId() {
        return this.lock.getGroupId();
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }

    @Override
    public void onDestroy() {
        ClientMessage msg = CPGroupDestroyCPObjectCodec.encodeRequest((RaftGroupId)this.lock.getGroupId(), this.getServiceName(), this.lock.getObjectName());
        new ClientInvocation(this.getClient(), msg, this.name).invoke().join();
    }

    @Override
    protected void postDestroy() {
        super.postDestroy();
        this.lock.destroy();
    }

    private class FencedLockImpl
    extends AbstractRaftFencedLockProxy {
        FencedLockImpl(AbstractProxySessionManager sessionManager, RaftGroupId groupId, String proxyName, String objectName) {
            super(sessionManager, groupId, proxyName, objectName);
        }

        @Override
        protected InternalCompletableFuture<Long> doLock(long sessionId, long threadId, UUID invocationUid) {
            ClientMessage request = CPFencedLockLockCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid);
            ClientInvocationFuture future = new ClientInvocation(RaftFencedLockProxy.this.getClient(), request, RaftFencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<Long>(future, RaftFencedLockProxy.this.getSerializationService(), LOCK_RESPONSE_DECODER);
        }

        @Override
        protected InternalCompletableFuture<Long> doTryLock(long sessionId, long threadId, UUID invocationUid, long timeoutMillis) {
            ClientMessage request = CPFencedLockTryLockCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid, timeoutMillis);
            ClientInvocationFuture future = new ClientInvocation(RaftFencedLockProxy.this.getClient(), request, RaftFencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<Long>(future, RaftFencedLockProxy.this.getSerializationService(), TRY_RESPONSE_DECODER);
        }

        @Override
        protected InternalCompletableFuture<Boolean> doUnlock(long sessionId, long threadId, UUID invocationUid) {
            ClientMessage request = CPFencedLockUnlockCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid);
            ClientInvocationFuture future = new ClientInvocation(RaftFencedLockProxy.this.getClient(), request, RaftFencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<Boolean>(future, RaftFencedLockProxy.this.getSerializationService(), UNLOCK_RESPONSE_DECODER);
        }

        @Override
        protected InternalCompletableFuture<RaftLockOwnershipState> doGetLockOwnershipState() {
            ClientMessage request = CPFencedLockGetLockOwnershipCodec.encodeRequest(this.groupId, this.objectName);
            ClientInvocationFuture future = new ClientInvocation(RaftFencedLockProxy.this.getClient(), request, RaftFencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<RaftLockOwnershipState>(future, RaftFencedLockProxy.this.getSerializationService(), GET_LOCK_OWNERSHIP_STATE_RESPONSE_DECODER);
        }
    }
}

