/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClientImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.ClientMembershipListener;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.Clock;
import com.hazelcast.util.UuidUtil;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ClientClusterServiceImpl
implements ClientClusterService {
    protected final HazelcastClientInstanceImpl client;
    private ClientMembershipListener clientMembershipListener;
    private final AtomicReference<Map<Address, Member>> members = new AtomicReference();
    private final ConcurrentMap<String, MembershipListener> listeners = new ConcurrentHashMap<String, MembershipListener>();
    private final Object initialMembershipListenerMutex = new Object();
    private final Set<String> labels;

    public ClientClusterServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.labels = Collections.unmodifiableSet(client.getClientConfig().getLabels());
        ILogger logger = client.getLoggingService().getLogger(ClientClusterService.class);
        ClientConfig clientConfig = this.getClientConfig();
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            EventListener listener = listenerConfig.getImplementation();
            if (listener == null) {
                try {
                    listener = (EventListener)ClassLoaderUtil.newInstance(clientConfig.getClassLoader(), listenerConfig.getClassName());
                }
                catch (Exception e) {
                    logger.severe(e);
                }
            }
            if (!(listener instanceof MembershipListener)) continue;
            this.addMembershipListenerWithoutInit((MembershipListener)listener);
        }
        this.members.set(Collections.unmodifiableMap(new LinkedHashMap()));
    }

    @Override
    public Member getMember(Address address) {
        return this.members.get().get(address);
    }

    @Override
    public Member getMember(String uuid) {
        Collection<Member> memberList = this.getMemberList();
        for (Member member : memberList) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Collection<Member> getMemberList() {
        return this.members.get().values();
    }

    @Override
    public Collection<Member> getMembers(MemberSelector selector) {
        return new MemberSelectingCollection<Member>(this.getMemberList(), selector);
    }

    @Override
    public Address getMasterAddress() {
        Collection<Member> memberList = this.getMemberList();
        return !memberList.isEmpty() ? new Address(memberList.iterator().next().getSocketAddress()) : null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public int getSize(MemberSelector selector) {
        int size = 0;
        for (Member member : this.getMemberList()) {
            if (!selector.select(member)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    @Override
    public Client getLocalClient() {
        ClientConnectionManager cm = this.client.getConnectionManager();
        ClientConnection connection = cm.getOwnerConnection();
        InetSocketAddress inetSocketAddress = connection != null ? connection.getLocalSocketAddress() : null;
        ClientPrincipal principal = cm.getPrincipal();
        String uuid = principal != null ? principal.getUuid() : null;
        return new ClientImpl(uuid, inetSocketAddress, this.client.getName(), this.labels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addMembershipListener(MembershipListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        Object object = this.initialMembershipListenerMutex;
        synchronized (object) {
            String id = this.addMembershipListenerWithoutInit(listener);
            this.initMembershipListener(listener);
            return id;
        }
    }

    private String addMembershipListenerWithoutInit(MembershipListener listener) {
        String id = UuidUtil.newUnsecureUuidString();
        this.listeners.put(id, listener);
        return id;
    }

    private void initMembershipListener(MembershipListener listener) {
        if (listener instanceof InitialMembershipListener) {
            Cluster cluster = this.client.getCluster();
            Collection<Member> memberCollection = this.members.get().values();
            if (memberCollection.isEmpty()) {
                return;
            }
            LinkedHashSet<Member> members = new LinkedHashSet<Member>(memberCollection);
            InitialMembershipEvent event = new InitialMembershipEvent(cluster, members);
            ((InitialMembershipListener)listener).init(event);
        }
    }

    @Override
    public boolean removeMembershipListener(String registrationId) {
        if (registrationId == null) {
            throw new NullPointerException("registrationId can't be null");
        }
        return this.listeners.remove(registrationId) != null;
    }

    public void listenMembershipEvents(Connection ownerConnection) throws Exception {
        this.clientMembershipListener.listenMembershipEvents(ownerConnection);
    }

    public void start() {
        this.clientMembershipListener = new ClientMembershipListener(this.client);
    }

    private ClientConfig getClientConfig() {
        return this.client.getClientConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleInitialMembershipEvent(InitialMembershipEvent event) {
        Object object = this.initialMembershipListenerMutex;
        synchronized (object) {
            Set<Member> initialMembers = event.getMembers();
            LinkedHashMap<Address, Member> newMap = new LinkedHashMap<Address, Member>();
            for (Member initialMember : initialMembers) {
                newMap.put(initialMember.getAddress(), initialMember);
            }
            this.members.set(Collections.unmodifiableMap(newMap));
            this.fireInitialMembershipEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMembershipEvent(MembershipEvent event) {
        Object object = this.initialMembershipListenerMutex;
        synchronized (object) {
            Member member = event.getMember();
            LinkedHashMap<Address, Member> newMap = new LinkedHashMap<Address, Member>(this.members.get());
            if (event.getEventType() == 1) {
                newMap.put(member.getAddress(), member);
            } else {
                newMap.remove(member.getAddress());
            }
            this.members.set(Collections.unmodifiableMap(newMap));
            this.fireMembershipEvent(event);
        }
    }

    private void fireInitialMembershipEvent(InitialMembershipEvent event) {
        for (MembershipListener listener : this.listeners.values()) {
            if (!(listener instanceof InitialMembershipListener)) continue;
            ((InitialMembershipListener)listener).init(event);
        }
    }

    private void fireMembershipEvent(MembershipEvent event) {
        for (MembershipListener listener : this.listeners.values()) {
            if (event.getEventType() == 1) {
                listener.memberAdded(event);
                continue;
            }
            listener.memberRemoved(event);
        }
    }

    void fireMemberAttributeEvent(MemberAttributeEvent event) {
        for (MembershipListener listener : this.listeners.values()) {
            listener.memberAttributeChanged(event);
        }
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeClusterSwitch(CandidateClusterContext context) {
        this.clientMembershipListener.beforeClusterSwitch(context);
        Object object = this.initialMembershipListenerMutex;
        synchronized (object) {
            this.members.set(Collections.emptyMap());
        }
    }
}

