/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.semaphore;

import com.hazelcast.config.cp.CPSemaphoreConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.datastructures.semaphore.AcquireInvocationKey;
import com.hazelcast.cp.internal.datastructures.semaphore.RaftSemaphore;
import com.hazelcast.cp.internal.datastructures.semaphore.RaftSemaphoreRegistry;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreEndpoint;
import com.hazelcast.cp.internal.datastructures.semaphore.proxy.RaftSessionAwareSemaphoreProxy;
import com.hazelcast.cp.internal.datastructures.semaphore.proxy.RaftSessionlessSemaphoreProxy;
import com.hazelcast.cp.internal.datastructures.spi.blocking.AbstractBlockingService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.UUID;

public class RaftSemaphoreService
extends AbstractBlockingService<AcquireInvocationKey, RaftSemaphore, RaftSemaphoreRegistry> {
    public static final String SERVICE_NAME = "hz:raft:semaphoreService";

    public RaftSemaphoreService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    private CPSemaphoreConfig getConfig(String name) {
        return this.nodeEngine.getConfig().getCPSubsystemConfig().findSemaphoreConfig(name);
    }

    public boolean initSemaphore(CPGroupId groupId, String name, int permits) {
        try {
            Collection<AcquireInvocationKey> acquired = ((RaftSemaphoreRegistry)this.getOrInitRegistry(groupId)).init(name, permits);
            this.notifyWaitKeys(groupId, name, acquired, true);
            return true;
        }
        catch (IllegalStateException ignored) {
            return false;
        }
    }

    public int availablePermits(CPGroupId groupId, String name) {
        RaftSemaphoreRegistry registry = (RaftSemaphoreRegistry)this.getRegistryOrNull(groupId);
        return registry != null ? registry.availablePermits(name) : 0;
    }

    public boolean acquirePermits(CPGroupId groupId, String name, AcquireInvocationKey key, long timeoutMs) {
        boolean success;
        this.heartbeatSession(groupId, key.sessionId());
        RaftSemaphore.AcquireResult result = ((RaftSemaphoreRegistry)this.getOrInitRegistry(groupId)).acquire(name, key, timeoutMs);
        boolean bl = success = result.acquired > 0;
        if (this.logger.isFineEnabled()) {
            if (success) {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " acquired permits: " + key.permits() + " by <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex());
            } else if (timeoutMs != 0L) {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " wait key added for permits: " + key.permits() + " by <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex());
            } else {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " not acquired permits: " + key.permits() + " by <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex());
            }
        }
        this.notifyCancelledWaitKeys(groupId, name, result.cancelled);
        if (!success) {
            this.scheduleTimeout(groupId, name, key.invocationUid(), timeoutMs);
            if (timeoutMs != 0L) {
                this.addLiveOperation(key);
            }
        }
        return success;
    }

    public void releasePermits(CPGroupId groupId, long commitIndex, String name, SemaphoreEndpoint endpoint, UUID invocationUid, int permits) {
        this.heartbeatSession(groupId, endpoint.sessionId());
        RaftSemaphore.ReleaseResult result = ((RaftSemaphoreRegistry)this.getOrInitRegistry(groupId)).release(name, endpoint, invocationUid, permits);
        this.notifyCancelledWaitKeys(groupId, name, result.cancelled);
        this.notifyWaitKeys(groupId, name, result.acquired, true);
        if (this.logger.isFineEnabled()) {
            if (result.success) {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " released permits: " + permits + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex + " new acquires: " + result.acquired);
            } else {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " not-released permits: " + permits + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex);
            }
        }
        if (!result.success) {
            throw new IllegalArgumentException();
        }
    }

    public int drainPermits(CPGroupId groupId, String name, long commitIndex, SemaphoreEndpoint endpoint, UUID invocationUid) {
        this.heartbeatSession(groupId, endpoint.sessionId());
        RaftSemaphore.AcquireResult result = ((RaftSemaphoreRegistry)this.getOrInitRegistry(groupId)).drainPermits(name, endpoint, invocationUid);
        this.notifyCancelledWaitKeys(groupId, name, result.cancelled);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Semaphore[" + name + "] in " + groupId + " drained permits: " + result.acquired + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex);
        }
        return result.acquired;
    }

    public boolean changePermits(CPGroupId groupId, long commitIndex, String name, SemaphoreEndpoint endpoint, UUID invocationUid, int permits) {
        this.heartbeatSession(groupId, endpoint.sessionId());
        RaftSemaphore.ReleaseResult result = ((RaftSemaphoreRegistry)this.getOrInitRegistry(groupId)).changePermits(name, endpoint, invocationUid, permits);
        this.notifyCancelledWaitKeys(groupId, name, result.cancelled);
        this.notifyWaitKeys(groupId, name, result.acquired, true);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Semaphore[" + name + "] in " + groupId + " changed permits: " + permits + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex + ". new acquires: " + result.acquired);
        }
        return result.success;
    }

    private void notifyCancelledWaitKeys(CPGroupId groupId, String name, Collection<AcquireInvocationKey> keys) {
        if (keys.isEmpty()) {
            return;
        }
        this.notifyWaitKeys(groupId, name, keys, new WaitKeyCancelledException());
    }

    @Override
    protected RaftSemaphoreRegistry createNewRegistry(CPGroupId groupId) {
        return new RaftSemaphoreRegistry(groupId);
    }

    @Override
    protected Object expiredWaitKeyResponse() {
        return false;
    }

    @Override
    protected String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public DistributedObject createDistributedObject(String proxyName) {
        try {
            RaftGroupId groupId = this.raftService.createRaftGroupForProxy(proxyName);
            String objectName = RaftService.getObjectNameForProxy(proxyName);
            CPSemaphoreConfig config = this.getConfig(proxyName);
            return config != null && config.isJDKCompatible() ? new RaftSessionlessSemaphoreProxy(this.nodeEngine, groupId, proxyName, objectName) : new RaftSessionAwareSemaphoreProxy(this.nodeEngine, groupId, proxyName, objectName);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void destroyDistributedObject(String objectName) {
    }
}

