/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ascii;

import com.hazelcast.config.EndpointConfig;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.ascii.MemcacheTextDecoder;
import com.hazelcast.nio.ascii.RestApiTextDecoder;
import com.hazelcast.nio.ascii.TextEncoder;
import com.hazelcast.nio.tcp.AbstractChannelInitializer;
import com.hazelcast.nio.tcp.TcpIpConnection;

public class TextChannelInitializer
extends AbstractChannelInitializer {
    private final boolean rest;

    public TextChannelInitializer(IOService ioService, EndpointConfig config, boolean rest) {
        super(ioService, config);
        this.rest = rest;
    }

    @Override
    public void initChannel(Channel channel) {
        super.initChannel(channel);
        TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
        TextEncoder encoder = new TextEncoder(connection);
        channel.outboundPipeline().addLast(encoder);
        channel.inboundPipeline().addLast(this.rest ? new RestApiTextDecoder(connection, encoder, true) : new MemcacheTextDecoder(connection, encoder, true));
    }
}

