/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.hibernate;

import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.util.ExceptionUtil;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RegionFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String CACHE_REGION_FACTORY = "com.hazelcast.hibernate.HazelcastCacheRegionFactory";
    private static final String LOCAL_CACHE_REGION_FACTORY = "com.hazelcast.hibernate.HazelcastLocalCacheRegionFactory";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Class<?> clz;
        String instanceRefName;
        block7: {
            NamedNodeMap attributes = element.getAttributes();
            instanceRefName = "instance";
            String mode = "DISTRIBUTED";
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node att = attributes.item(a);
                    String name = att.getNodeName();
                    if ("instance-ref".equals(name)) {
                        instanceRefName = att.getTextContent();
                        continue;
                    }
                    if (!"mode".equals(name)) continue;
                    mode = att.getTextContent();
                }
            }
            clz = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                if ("DISTRIBUTED".equals(mode)) {
                    clz = ClassLoaderUtil.loadClass(classLoader, CACHE_REGION_FACTORY);
                    break block7;
                }
                if ("LOCAL".equals(mode)) {
                    clz = ClassLoaderUtil.loadClass(classLoader, LOCAL_CACHE_REGION_FACTORY);
                    break block7;
                }
                throw new IllegalArgumentException("Unknown Hibernate L2 cache mode: " + mode);
            }
            catch (ClassNotFoundException e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(clz);
        builder.addConstructorArgReference(instanceRefName);
        return builder.getBeanDefinition();
    }
}

