/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.nio.Connection;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.util.ExceptionUtil;

public final class ClientTransactionUtil {
    private static final ExceptionUtil.ExceptionWrapper<RuntimeException> TRANSACTION_EXCEPTION_WRAPPER = new ExceptionUtil.ExceptionWrapper<RuntimeException>(){

        @Override
        public RuntimeException create(Throwable throwable, String message) {
            return new TransactionException(message, throwable);
        }
    };

    private ClientTransactionUtil() {
    }

    public static ClientMessage invoke(ClientMessage request, String objectName, HazelcastClientInstanceImpl client, Connection connection) {
        try {
            ClientInvocation clientInvocation = new ClientInvocation(client, request, objectName, connection);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e, TRANSACTION_EXCEPTION_WRAPPER);
        }
    }
}

