/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.kubernetes.DnsEndpointResolver;
import com.hazelcast.kubernetes.KubernetesApiEndpointResolver;
import com.hazelcast.kubernetes.KubernetesClient;
import com.hazelcast.kubernetes.KubernetesProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class HazelcastKubernetesDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final String DEFAULT_MASTER_URL = "https://kubernetes.default.svc";
    private static final int DEFAULT_SERVICE_DNS_TIMEOUT_SECONDS = 5;
    private final String namespace;
    private final KubernetesClient client;
    private final EndpointResolver endpointResolver;
    private final Map<String, Object> memberMetadata = new HashMap<String, Object>();

    HazelcastKubernetesDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        String caCertificate;
        String serviceDns = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_DNS);
        int serviceDnsTimeout = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_DNS_TIMEOUT, 5);
        String serviceName = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_NAME);
        int port = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_PORT, 0);
        String serviceLabel = (String)this.getOrNull(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_LABEL_NAME);
        String serviceLabelValue = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.SERVICE_LABEL_VALUE, "true");
        this.namespace = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.NAMESPACE, this.getNamespaceOrDefault());
        Boolean resolveNotReadyAddresses = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.RESOLVE_NOT_READY_ADDRESSES, false);
        String kubernetesMaster = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_MASTER_URL, DEFAULT_MASTER_URL);
        String apiToken = this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_API_TOKEN, null);
        if (apiToken == null) {
            apiToken = HazelcastKubernetesDiscoveryStrategy.readAccountToken();
        }
        if ((caCertificate = (String)this.getOrDefault(properties, "hazelcast.kubernetes.", KubernetesProperties.KUBERNETES_CA_CERTIFICATE, null)) == null) {
            caCertificate = HazelcastKubernetesDiscoveryStrategy.readCaCertificate();
        }
        logger.info("Kubernetes Discovery properties: { service-dns: " + serviceDns + ", service-dns-timeout: " + serviceDnsTimeout + ", service-name: " + serviceName + ", service-port: " + port + ", service-label: " + serviceLabel + ", service-label-value: " + serviceLabelValue + ", namespace: " + this.namespace + ", resolve-not-ready-addresses: " + resolveNotReadyAddresses + ", kubernetes-master: " + kubernetesMaster + "}");
        this.client = this.buildKubernetesClient(this.namespace, kubernetesMaster, apiToken, caCertificate);
        this.endpointResolver = serviceDns != null ? new DnsEndpointResolver(logger, serviceDns, port, serviceDnsTimeout) : new KubernetesApiEndpointResolver(logger, serviceName, port, serviceLabel, serviceLabelValue, resolveNotReadyAddresses, this.client);
        logger.info("Kubernetes Discovery activated resolver: " + this.endpointResolver.getClass().getSimpleName());
    }

    private String getNamespaceOrDefault() {
        String namespace = System.getenv("KUBERNETES_NAMESPACE");
        if (namespace == null && (namespace = System.getenv("OPENSHIFT_BUILD_NAMESPACE")) == null) {
            namespace = "default";
        }
        return namespace;
    }

    @Override
    public void start() {
        this.endpointResolver.start();
    }

    @Override
    public Map<String, Object> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            this.memberMetadata.put("hazelcast.partition.group.zone", this.discoverZone());
        }
        return this.memberMetadata;
    }

    private String discoverZone() {
        try {
            String zone;
            String podName = System.getenv("POD_NAME");
            if (podName == null) {
                podName = System.getenv("HOSTNAME");
            }
            if (podName == null) {
                podName = InetAddress.getLocalHost().getHostName();
            }
            if ((zone = this.client.zone(podName)) != null) {
                return zone;
            }
        }
        catch (Exception e) {
            this.getLogger().finest(e);
        }
        this.getLogger().warning("Cannot fetch the current zone, ZONE_AWARE feature is disabled");
        return "unknown";
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        return this.endpointResolver.resolve();
    }

    @Override
    public void destroy() {
        this.endpointResolver.destroy();
    }

    protected <T extends Comparable> T getOrNull(Map<String, Comparable> properties, String prefix, PropertyDefinition property) {
        return this.getOrDefault(properties, prefix, property, null);
    }

    protected <T extends Comparable> T getOrDefault(Map<String, Comparable> properties, String prefix, PropertyDefinition property, T defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        Comparable value = this.readProperty(prefix, property);
        if (value == null) {
            value = properties.get(property.key());
        }
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    private Comparable readProperty(String prefix, PropertyDefinition property) {
        if (prefix != null) {
            String p = this.getProperty(prefix, property);
            String v = System.getProperty(p);
            if (StringUtil.isNullOrEmpty(v) && StringUtil.isNullOrEmpty(v = System.getenv(p))) {
                v = System.getenv(this.cIdentifierLike(p));
            }
            if (!StringUtil.isNullOrEmpty(v)) {
                return property.typeConverter().convert((Comparable)((Object)v));
            }
        }
        return null;
    }

    private String cIdentifierLike(String property) {
        property = property.toUpperCase();
        property = property.replace(".", "_");
        return property.replace("-", "_");
    }

    private String getProperty(String prefix, PropertyDefinition property) {
        StringBuilder sb = new StringBuilder(prefix);
        if (prefix.charAt(prefix.length() - 1) != '.') {
            sb.append('.');
        }
        return sb.append(property.key()).toString();
    }

    private KubernetesClient buildKubernetesClient(String namespace, String kubernetesMaster, String accessToken, String caCertificate) {
        return new KubernetesClient(namespace, kubernetesMaster, accessToken, caCertificate);
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static String readAccountToken() {
        return HazelcastKubernetesDiscoveryStrategy.readFileContents("/var/run/secrets/kubernetes.io/serviceaccount/token");
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static String readCaCertificate() {
        return HazelcastKubernetesDiscoveryStrategy.readFileContents("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
    }

    protected static String readFileContents(String tokenFile) {
        String string;
        FileInputStream is = null;
        try {
            File file = new File(tokenFile);
            byte[] data = new byte[(int)file.length()];
            is = new FileInputStream(file);
            ((InputStream)is).read(data);
            string = new String(data, "UTF-8");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not get token file", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(is);
                throw throwable;
            }
        }
        IOUtil.closeResource(is);
        return string;
    }

    static abstract class EndpointResolver {
        protected final ILogger logger;

        EndpointResolver(ILogger logger) {
            this.logger = logger;
        }

        abstract List<DiscoveryNode> resolve();

        void start() {
        }

        void destroy() {
        }

        protected InetAddress mapAddress(String address) {
            if (address == null) {
                return null;
            }
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                this.logger.warning("Address '" + address + "' could not be resolved");
                return null;
            }
        }
    }
}

