/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.PutOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class MapPutRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    protected Data key;
    protected Data value;
    protected String name;
    protected long threadId;
    protected long ttl;
    protected transient long startTime;

    public MapPutRequest() {
    }

    public MapPutRequest(String name, Data key, Data value, long threadId, long ttl) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.threadId = threadId;
        this.ttl = ttl;
    }

    public MapPutRequest(String name, Data key, Data value, long threadId) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.threadId = threadId;
        this.ttl = -1L;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void afterResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService();
        MapContainer mapContainer = mapService.getMapContainer(this.name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getLocalMapStatsImpl(this.name).incrementPuts(latency);
        }
    }

    @Override
    protected Operation prepareOperation() {
        PutOperation op = new PutOperation(this.name, this.key, this.value, this.ttl);
        op.setThreadId(this.threadId);
        return op;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.threadId);
        writer.writeLong("ttl", this.ttl);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        this.value.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.threadId = reader.readLong("t");
        this.ttl = reader.readLong("ttl");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put");
    }
}

