/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.operation.BasePutOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class TryPutOperation
extends BasePutOperation {
    private long timeout;
    private boolean successful;

    public TryPutOperation(String name, Data dataKey, Data value, long timeout) {
        super(name, dataKey, value);
        this.timeout = timeout;
    }

    public TryPutOperation() {
    }

    @Override
    public void run() {
        this.successful = this.recordStore.tryPut(this.dataKey, this.dataValue, this.ttl);
    }

    @Override
    public void afterRun() {
        if (this.successful) {
            super.afterRun();
        }
    }

    @Override
    public long getWaitTimeoutMillis() {
        return this.timeout;
    }

    @Override
    public boolean shouldBackup() {
        return this.successful;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    public Object getResponse() {
        return this.successful;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timeout);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timeout = in.readLong();
    }

    @Override
    public String toString() {
        return "TryPutOperation{" + this.name + "}";
    }
}

