/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.RecordInfo;
import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class RecordReplicationInfo
extends RecordInfo
implements DataSerializable {
    private Data key;
    private Data value;

    public RecordReplicationInfo(Data key, Data value, RecordStatistics statistics, long idleDelayMillis, long ttlDelayMillis, long mapStoreWriteDelayMillis, long mapStoreDeleteDelayMillis) {
        this.key = key;
        this.value = value;
        this.statistics = statistics;
        this.idleDelayMillis = idleDelayMillis;
        this.ttlDelayMillis = ttlDelayMillis;
        this.mapStoreWriteDelayMillis = mapStoreWriteDelayMillis;
        this.mapStoreDeleteDelayMillis = mapStoreDeleteDelayMillis;
    }

    public RecordReplicationInfo() {
    }

    public Data getKey() {
        return this.key;
    }

    public Data getValue() {
        return this.value;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        this.key.writeData(out);
        this.value.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public String toString() {
        return "RecordReplicationInfo{key=" + this.key + ", value=" + this.value + "} " + super.toString();
    }
}

