/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl.task;

import com.hazelcast.mapreduce.Context;
import com.hazelcast.mapreduce.KeyPredicate;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MappingPhase<KeyIn, ValueIn, KeyOut, ValueOut> {
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Collection<KeyIn> keys;
    private final KeyPredicate<KeyIn> predicate;

    public MappingPhase(Collection<KeyIn> keys, KeyPredicate<KeyIn> predicate) {
        this.keys = keys;
        this.predicate = predicate;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    protected boolean isCancelled() {
        return this.cancelled.get();
    }

    protected boolean matches(KeyIn key) {
        if ((this.keys == null || this.keys.size() == 0) && this.predicate == null) {
            return true;
        }
        if (this.keys != null && this.keys.size() > 0) {
            for (KeyIn matcher : this.keys) {
                if (!key.equals(matcher)) continue;
                return true;
            }
        }
        return this.predicate != null && this.predicate.evaluate(key);
    }

    protected abstract void executeMappingPhase(KeyValueSource<KeyIn, ValueIn> var1, Mapper<KeyIn, ValueIn, KeyOut, ValueOut> var2, Context<KeyOut, ValueOut> var3);
}

