/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.ByteArrayObjectDataInput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.IOException;
import java.nio.ByteOrder;

final class UnsafeObjectDataInput
extends ByteArrayObjectDataInput {
    UnsafeObjectDataInput(Data data, SerializationService service) {
        super(data, service);
    }

    UnsafeObjectDataInput(byte[] buffer, SerializationService service) {
        super(buffer, service);
    }

    @Override
    public char readChar() throws IOException {
        char c = this.readChar(this.pos);
        this.pos += 2;
        return c;
    }

    @Override
    public char readChar(int position) throws IOException {
        this.checkAvailable(position, 2);
        return UnsafeHelper.UNSAFE.getChar(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public double readDouble() throws IOException {
        double d = this.readDouble(this.pos);
        this.pos += 8;
        return d;
    }

    @Override
    public double readDouble(int position) throws IOException {
        this.checkAvailable(position, 8);
        return UnsafeHelper.UNSAFE.getDouble(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public float readFloat() throws IOException {
        float f = this.readFloat(this.pos);
        this.pos += 4;
        return f;
    }

    @Override
    public float readFloat(int position) throws IOException {
        this.checkAvailable(position, 4);
        return UnsafeHelper.UNSAFE.getFloat(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public int readInt() throws IOException {
        int i = this.readInt(this.pos);
        this.pos += 4;
        return i;
    }

    @Override
    public int readInt(int position) throws IOException {
        this.checkAvailable(position, 4);
        return UnsafeHelper.UNSAFE.getInt(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public long readLong() throws IOException {
        long l = this.readLong(this.pos);
        this.pos += 8;
        return l;
    }

    @Override
    public long readLong(int position) throws IOException {
        this.checkAvailable(position, 8);
        return UnsafeHelper.UNSAFE.getLong(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public short readShort() throws IOException {
        short s = this.readShort(this.pos);
        this.pos += 2;
        return s;
    }

    @Override
    public short readShort(int position) throws IOException {
        this.checkAvailable(position, 2);
        return UnsafeHelper.UNSAFE.getShort(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public char[] readCharArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            char[] values = new char[len];
            this.unsafeMemCopy(values, UnsafeHelper.CHAR_ARRAY_BASE_OFFSET, len, UnsafeHelper.CHAR_ARRAY_INDEX_SCALE);
            return values;
        }
        return new char[0];
    }

    @Override
    public int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            int[] values = new int[len];
            this.unsafeMemCopy(values, UnsafeHelper.INT_ARRAY_BASE_OFFSET, len, UnsafeHelper.INT_ARRAY_INDEX_SCALE);
            return values;
        }
        return new int[0];
    }

    @Override
    public long[] readLongArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            long[] values = new long[len];
            this.unsafeMemCopy(values, UnsafeHelper.LONG_ARRAY_BASE_OFFSET, len, UnsafeHelper.LONG_ARRAY_INDEX_SCALE);
            return values;
        }
        return new long[0];
    }

    @Override
    public double[] readDoubleArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            double[] values = new double[len];
            this.unsafeMemCopy(values, UnsafeHelper.DOUBLE_ARRAY_BASE_OFFSET, len, UnsafeHelper.DOUBLE_ARRAY_INDEX_SCALE);
            return values;
        }
        return new double[0];
    }

    @Override
    public float[] readFloatArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            float[] values = new float[len];
            this.unsafeMemCopy(values, UnsafeHelper.FLOAT_ARRAY_BASE_OFFSET, len, UnsafeHelper.FLOAT_ARRAY_INDEX_SCALE);
            return values;
        }
        return new float[0];
    }

    @Override
    public short[] readShortArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            short[] values = new short[len];
            this.unsafeMemCopy(values, UnsafeHelper.SHORT_ARRAY_BASE_OFFSET, len, UnsafeHelper.SHORT_ARRAY_INDEX_SCALE);
            return values;
        }
        return new short[0];
    }

    private void unsafeMemCopy(Object destArray, long destArrayTypeOffset, int destArrayLength, int indexScale) throws IOException {
        if (destArray == null) {
            throw new IllegalArgumentException("Destination array is NULL!");
        }
        if (destArrayLength < 0) {
            throw new NegativeArraySizeException("Destination array length is negative: " + destArrayLength);
        }
        int len = destArrayLength * indexScale;
        this.checkAvailable(this.pos, len);
        UnsafeHelper.UNSAFE.copyMemory(this.buffer, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, destArray, destArrayTypeOffset, len);
        this.pos += len;
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.nativeOrder();
    }

    private void checkAvailable(int pos, int k) throws IOException {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative pos! -> " + pos);
        }
        if (this.size - pos < k) {
            throw new IOException("Cannot read " + k + " bytes!");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UnsafeObjectDataInput");
        sb.append("{size=").append(this.size);
        sb.append(", pos=").append(this.pos);
        sb.append(", mark=").append(this.mark);
        sb.append(", byteOrder=").append(this.getByteOrder());
        sb.append('}');
        return sb.toString();
    }
}

