/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.util.Clock;

final class ReplicaSyncInfo {
    final int partitionId;
    final int replicaIndex;
    final long requestTime = Clock.currentTimeMillis();
    final Address target;

    ReplicaSyncInfo(int partitionId, int replicaIndex, Address target) {
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaSyncInfo that = (ReplicaSyncInfo)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        return this.replicaIndex == that.replicaIndex;
    }

    public int hashCode() {
        int result = this.partitionId;
        result = 31 * result + this.replicaIndex;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicaSyncInfo{");
        sb.append("partitionId=").append(this.partitionId);
        sb.append(", replicaIndex=").append(this.replicaIndex);
        sb.append(", requestTime=").append(this.requestTime);
        sb.append(", target=").append(this.target);
        sb.append('}');
        return sb.toString();
    }
}

