/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.idgen;

import com.hazelcast.concurrent.idgen.IdGeneratorService;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.NodeEngine;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class IdGeneratorProxy
extends AbstractDistributedObject<IdGeneratorService>
implements IdGenerator {
    public static final int BLOCK_SIZE = 10000;
    private final String name;
    private final IAtomicLong blockGenerator;
    private final AtomicInteger residue = new AtomicInteger(10000);
    private final AtomicLong local = new AtomicLong(-1L);

    public IdGeneratorProxy(IAtomicLong blockGenerator, String name, NodeEngine nodeEngine, IdGeneratorService service) {
        super(nodeEngine, service);
        this.name = name;
        this.blockGenerator = blockGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(long id) {
        if (id <= 0L) {
            return false;
        }
        long step = id / 10000L;
        IdGeneratorProxy idGeneratorProxy = this;
        synchronized (idGeneratorProxy) {
            boolean init = this.blockGenerator.compareAndSet(0L, step + 1L);
            if (init) {
                this.local.set(step);
                this.residue.set((int)(id % 10000L) + 1);
            }
            return init;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long newId() {
        int value = this.residue.getAndIncrement();
        if (value >= 10000) {
            IdGeneratorProxy idGeneratorProxy = this;
            synchronized (idGeneratorProxy) {
                value = this.residue.get();
                if (value >= 10000) {
                    this.local.set(this.blockGenerator.getAndIncrement());
                    this.residue.set(0);
                }
                return this.newId();
            }
        }
        return this.local.get() * 10000L + (long)value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:idGeneratorService";
    }

    @Override
    protected void postDestroy() {
        this.blockGenerator.destroy();
        this.local.set(-1L);
        this.residue.set(10000);
    }
}

