/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.executor.DistributedExecutorService;
import com.hazelcast.executor.ExecutorPortableHook;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.security.Permission;

public class IsShutdownRequest
extends CallableClientRequest
implements RetryableRequest {
    private String name;

    public IsShutdownRequest() {
    }

    public IsShutdownRequest(String name) {
        this.name = name;
    }

    public Object call() throws Exception {
        DistributedExecutorService service = (DistributedExecutorService)this.getService();
        return service.isShutdown(this.name);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

