/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.Member;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

@SuppressWarnings(value={"SE_BAD_FIELD"})
public class DataAwareEntryEvent
extends EntryEvent {
    private static final long serialVersionUID = 1L;
    protected final Data dataKey;
    protected final Data dataNewValue;
    protected final Data dataOldValue;
    private final transient SerializationService serializationService;

    public DataAwareEntryEvent(Member from, int eventType, String source, Data dataKey, Data dataNewValue, Data dataOldValue, SerializationService serializationService) {
        super(source, from, eventType, null, null);
        this.dataKey = dataKey;
        this.dataNewValue = dataNewValue;
        this.dataOldValue = dataOldValue;
        this.serializationService = serializationService;
    }

    public Data getKeyData() {
        return this.dataKey;
    }

    public Data getNewValueData() {
        return this.dataNewValue;
    }

    public Data getOldValueData() {
        return this.dataOldValue;
    }

    public Object getKey() {
        if (this.key == null && this.dataKey != null) {
            this.key = this.serializationService.toObject(this.dataKey);
        }
        return this.key;
    }

    public Object getOldValue() {
        if (this.oldValue == null && this.dataOldValue != null) {
            this.oldValue = this.serializationService.toObject(this.dataOldValue);
        }
        return this.oldValue;
    }

    public Object getValue() {
        if (this.value == null && this.dataNewValue != null) {
            this.value = this.serializationService.toObject(this.dataNewValue);
        }
        return this.value;
    }

    public String getLongName() {
        return this.name;
    }
}

