/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MapStoreWriteProcessor
implements ScheduledEntryProcessor<Data, Object> {
    private final MapContainer mapContainer;
    private final MapService mapService;
    private final ILogger logger;

    public MapStoreWriteProcessor(MapContainer mapContainer, MapService mapService) {
        this.mapContainer = mapContainer;
        this.mapService = mapService;
        this.logger = mapService.getNodeEngine().getLogger(this.getClass());
    }

    private Exception tryStore(EntryTaskScheduler<Data, Object> scheduler, Map.Entry<Data, Object> entry) {
        Exception exception = null;
        try {
            this.mapContainer.getStore().store(this.mapService.toObject(entry.getKey()), this.mapService.toObject(entry.getValue()));
        }
        catch (Exception e) {
            this.logger.warning(this.mapContainer.getStore().getMapStore().getClass() + " --> store failed, " + "now Hazelcast reschedules this operation ", e);
            exception = e;
            scheduler.schedule(this.mapContainer.getWriteDelayMillis(), this.mapService.toData(entry.getKey()), this.mapService.toData(entry.getValue()));
        }
        return exception;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        NodeEngine nodeEngine = this.mapService.getNodeEngine();
        if (entries.size() == 1) {
            Exception exception;
            ScheduledEntry<Data, Object> entry = entries.iterator().next();
            int partitionId = nodeEngine.getPartitionService().getPartitionId(entry.getKey());
            if (nodeEngine.getThisAddress().equals(nodeEngine.getPartitionService().getPartitionOwner(partitionId)) && (exception = this.tryStore(scheduler, entry)) != null) {
                this.logger.severe(exception);
            }
        } else {
            ScheduledEntry scheduledEntry;
            LinkedList<ScheduledEntry<Object, Object>> duplicateKeys = new LinkedList<ScheduledEntry<Object, Object>>();
            HashMap<Object, Object> map = new HashMap<Object, Object>(entries.size());
            for (ScheduledEntry<Data, Object> scheduledEntry2 : entries) {
                int partitionId = nodeEngine.getPartitionService().getPartitionId(scheduledEntry2.getKey());
                if (!nodeEngine.getThisAddress().equals(nodeEngine.getPartitionService().getPartitionOwner(partitionId))) continue;
                Object key = this.mapService.toObject(scheduledEntry2.getKey());
                if (map.get(key) != null) {
                    duplicateKeys.offer(new ScheduledEntry<Object, Object>(key, scheduledEntry2.getValue(), scheduledEntry2.getScheduledDelayMillis(), scheduledEntry2.getActualDelaySeconds(), scheduledEntry2.getScheduleTimeNanos()));
                    continue;
                }
                map.put(key, this.mapService.toObject(scheduledEntry2.getValue()));
            }
            for (ScheduledEntry<Data, Object> scheduledEntry3 : duplicateKeys) {
                Exception ex;
                Data key = scheduledEntry3.getKey();
                Object removed = map.remove(key);
                if (removed == null || (ex = this.tryStore(scheduler, new AbstractMap.SimpleEntry<Data, Object>(key, removed))) == null) continue;
                this.logger.severe(ex);
            }
            Exception exception = null;
            try {
                this.mapContainer.getStore().storeAll((Map)map);
            }
            catch (Exception exception2) {
                this.logger.warning(this.mapContainer.getStore().getMapStore().getClass() + " --> storeAll was failed, " + "now Hazelcast is trying to store one by one: ", exception2);
                for (ScheduledEntry<Data, Object> entry3 : entries) {
                    Exception temp = this.tryStore(scheduler, entry3);
                    if (temp == null) continue;
                    exception = temp;
                }
            }
            while ((scheduledEntry = (ScheduledEntry)duplicateKeys.poll()) != null) {
                Exception temp = this.tryStore(scheduler, scheduledEntry);
                if (temp == null) continue;
                exception = temp;
            }
            if (exception != null) {
                this.logger.severe(exception);
            }
        }
    }
}

