/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class RecordInfo
implements DataSerializable {
    protected RecordStatistics statistics;
    protected long idleDelayMillis = -1L;
    protected long ttlDelayMillis = -1L;
    protected long mapStoreWriteDelayMillis = -1L;
    protected long mapStoreDeleteDelayMillis = -1L;
    protected long version;

    public RecordInfo() {
    }

    public RecordInfo(RecordInfo recordInfo) {
        this.statistics = recordInfo.statistics;
        this.idleDelayMillis = recordInfo.idleDelayMillis;
        this.ttlDelayMillis = recordInfo.ttlDelayMillis;
        this.mapStoreWriteDelayMillis = recordInfo.mapStoreWriteDelayMillis;
        this.mapStoreDeleteDelayMillis = recordInfo.mapStoreDeleteDelayMillis;
        this.version = recordInfo.version;
    }

    public RecordStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(RecordStatistics statistics) {
        this.statistics = statistics;
    }

    public long getIdleDelayMillis() {
        return this.idleDelayMillis;
    }

    public void setIdleDelayMillis(long idleDelayMillis) {
        this.idleDelayMillis = idleDelayMillis;
    }

    public long getTtlDelayMillis() {
        return this.ttlDelayMillis;
    }

    public void setTtlDelayMillis(long ttlDelayMillis) {
        this.ttlDelayMillis = ttlDelayMillis;
    }

    public long getMapStoreWriteDelayMillis() {
        return this.mapStoreWriteDelayMillis;
    }

    public void setMapStoreWriteDelayMillis(long mapStoreWriteDelayMillis) {
        this.mapStoreWriteDelayMillis = mapStoreWriteDelayMillis;
    }

    public long getMapStoreDeleteDelayMillis() {
        return this.mapStoreDeleteDelayMillis;
    }

    public void setMapStoreDeleteDelayMillis(long mapStoreDeleteDelayMillis) {
        this.mapStoreDeleteDelayMillis = mapStoreDeleteDelayMillis;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (this.statistics != null) {
            out.writeBoolean(true);
            this.statistics.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.idleDelayMillis);
        out.writeLong(this.ttlDelayMillis);
        out.writeLong(this.mapStoreWriteDelayMillis);
        out.writeLong(this.mapStoreDeleteDelayMillis);
        out.writeLong(this.version);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        boolean statsEnabled = in.readBoolean();
        if (statsEnabled) {
            this.statistics = new RecordStatistics();
            this.statistics.readData(in);
        }
        this.idleDelayMillis = in.readLong();
        this.ttlDelayMillis = in.readLong();
        this.mapStoreWriteDelayMillis = in.readLong();
        this.mapStoreDeleteDelayMillis = in.readLong();
        this.version = in.readLong();
    }

    public String toString() {
        return "RecordInfo{statistics=" + this.statistics + ", idleDelayMillis=" + this.idleDelayMillis + ", ttlDelayMillis=" + this.ttlDelayMillis + ", mapStoreWriteDelayMillis=" + this.mapStoreWriteDelayMillis + ", mapStoreDeleteDelayMillis=" + this.mapStoreDeleteDelayMillis + ", version=" + this.version + '}';
    }
}

