/*
 * Copyright (c) 2008-2013, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.nio;

import java.nio.channels.SelectionKey;

final class OutSelectorImpl extends AbstractIOSelector {

    OutSelectorImpl(IOService ioService, int id) {
        super(ioService, ioService.getThreadPrefix() + "out-" + id);
    }

    protected void handleSelectionKey(SelectionKey sk) {
        if (sk.isValid() && sk.isWritable()) {
            sk.interestOps(sk.interestOps() & ~SelectionKey.OP_WRITE);
            final SelectionHandler handler = (SelectionHandler) sk.attachment();
            handler.handle();
        }
    }
}
