/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.txn.RecoverAllTransactionsRequest;
import com.hazelcast.client.txn.RecoverTransactionRequest;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.TransactionProxy;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.util.ExceptionUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.Xid;

public class ClientTransactionManager {
    final HazelcastClient client;
    final ConcurrentMap<SerializableXID, TransactionProxy> managedTransactions = new ConcurrentHashMap<SerializableXID, TransactionProxy>();
    final ConcurrentMap<SerializableXID, ClientConnection> recoveredTransactions = new ConcurrentHashMap<SerializableXID, ClientConnection>();

    public ClientTransactionManager(HazelcastClient client) {
        this.client = client;
    }

    public HazelcastClient getClient() {
        return this.client;
    }

    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return new TransactionContextProxy(this, options);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        TransactionContext context = this.newTransactionContext(options);
        context.beginTransaction();
        try {
            T value = task.execute(context);
            context.commitTransaction();
            return value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                throw (TransactionException)e;
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    public void addManagedTransaction(Xid xid, TransactionProxy transaction) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        transaction.setXid(sXid);
        this.managedTransactions.put(sXid, transaction);
    }

    public TransactionProxy getManagedTransaction(Xid xid) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        return (TransactionProxy)this.managedTransactions.get(sXid);
    }

    public void removeManagedTransaction(Xid xid) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        this.managedTransactions.remove(sXid);
    }

    ClientConnection connect() {
        try {
            return this.client.getConnectionManager().tryToConnect(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Xid[] recover() {
        SerializationService serializationService = this.client.getSerializationService();
        ClientInvocationServiceImpl invocationService = (ClientInvocationServiceImpl)this.client.getInvocationService();
        Xid[] empty = new Xid[]{};
        try {
            ClientConnection connection = this.connect();
            if (connection == null) {
                return empty;
            }
            RecoverAllTransactionsRequest request = new RecoverAllTransactionsRequest();
            ICompletableFuture future = invocationService.send((ClientRequest)request, connection);
            SerializableCollection collectionWrapper = (SerializableCollection)serializationService.toObject(future.get());
            for (Data data : collectionWrapper) {
                SerializableXID xid = (SerializableXID)serializationService.toObject(data);
                this.recoveredTransactions.put(xid, connection);
            }
            Set xidSet = this.recoveredTransactions.keySet();
            return xidSet.toArray(new Xid[xidSet.size()]);
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
            return empty;
        }
    }

    public boolean recover(Xid xid, boolean commit) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        ClientConnection connection = (ClientConnection)this.recoveredTransactions.remove(sXid);
        if (connection == null) {
            return false;
        }
        ClientInvocationServiceImpl invocationService = (ClientInvocationServiceImpl)this.client.getInvocationService();
        RecoverTransactionRequest request = new RecoverTransactionRequest(sXid, commit);
        try {
            ICompletableFuture future = invocationService.send((ClientRequest)request, connection);
            future.get();
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
        }
        return true;
    }

    public void shutdown() {
        this.managedTransactions.clear();
        this.recoveredTransactions.clear();
    }
}

