/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.eviction;

import com.hazelcast.map.eviction.AbstractReachabilityHandler;
import com.hazelcast.map.record.Record;

class TTLReachabilityHandler
extends AbstractReachabilityHandler {
    @Override
    public Record handle(Record record, long criteria, long timeInNanos) {
        if (record == null) {
            return null;
        }
        long ttl = record.getTtl();
        if (ttl < 1L) {
            return record;
        }
        long lastUpdatedTime = record.getLastUpdateTime();
        assert (ttl > 0L) : TTLReachabilityHandler.log("wrong ttl %d", ttl);
        assert (lastUpdatedTime > 0L);
        assert (timeInNanos > 0L);
        assert (timeInNanos >= lastUpdatedTime) : TTLReachabilityHandler.log("time >= lastUpdateTime (%d >= %d)", timeInNanos, lastUpdatedTime);
        boolean result = timeInNanos - lastUpdatedTime >= ttl;
        return result ? null : record;
    }

    @Override
    public short niceNumber() {
        return 0;
    }
}

