/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.PutAllBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordInfo;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PutAllOperation
extends AbstractMapOperation
implements PartitionAwareOperation,
BackupAwareOperation {
    private MapEntrySet entrySet;
    private boolean initialLoad = false;
    private List<Map.Entry<Data, Data>> backupEntrySet;
    private List<RecordInfo> backupRecordInfos;

    public PutAllOperation(String name, MapEntrySet entrySet) {
        super(name);
        this.entrySet = entrySet;
    }

    public PutAllOperation(String name, MapEntrySet entrySet, boolean initialLoad) {
        super(name);
        this.entrySet = entrySet;
        this.initialLoad = initialLoad;
    }

    public PutAllOperation() {
    }

    @Override
    public void run() {
        this.backupRecordInfos = new ArrayList<RecordInfo>();
        this.backupEntrySet = new ArrayList<Map.Entry<Data, Data>>();
        int partitionId = this.getPartitionId();
        RecordStore recordStore = this.mapService.getRecordStore(partitionId, this.name);
        Set<Map.Entry<Data, Data>> entries = this.entrySet.getEntrySet();
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        HashSet<Data> keysToInvalidate = new HashSet<Data>();
        for (Map.Entry<Data, Data> entry : entries) {
            Data dataKey = entry.getKey();
            Data dataValue = entry.getValue();
            if (partitionId != partitionService.getPartitionId(dataKey)) continue;
            Data dataOldValue = null;
            if (this.initialLoad) {
                recordStore.putFromLoad(dataKey, dataValue, -1L);
            } else {
                dataOldValue = this.mapService.toData(recordStore.put(dataKey, dataValue, -1L));
            }
            this.mapService.interceptAfterPut(this.name, dataValue);
            EntryEventType eventType = dataOldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
            this.mapService.publishEvent(this.getCallerAddress(), this.name, eventType, dataKey, dataOldValue, dataValue);
            keysToInvalidate.add(dataKey);
            if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
                Record record = recordStore.getRecord(dataKey);
                SimpleEntryView<Data, Data> entryView = this.mapService.createSimpleEntryView(dataKey, this.mapService.toData(dataValue), record);
                this.mapService.publishWanReplicationUpdate(this.name, entryView);
            }
            this.backupEntrySet.add(entry);
            RecordInfo replicationInfo = this.mapService.createRecordInfo(recordStore.getRecord(dataKey));
            this.backupRecordInfos.add(replicationInfo);
        }
        this.invalidateNearCaches(keysToInvalidate);
    }

    protected final void invalidateNearCaches(Set<Data> keys) {
        if (this.mapService.isNearCacheAndInvalidationEnabled(this.name)) {
            this.mapService.invalidateAllNearCaches(this.name, keys);
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "PutAllOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entrySet);
        out.writeBoolean(this.initialLoad);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entrySet = (MapEntrySet)in.readObject();
        this.initialLoad = in.readBoolean();
    }

    @Override
    public boolean shouldBackup() {
        return !this.backupEntrySet.isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutAllBackupOperation(this.name, this.backupEntrySet, this.backupRecordInfos);
    }
}

