/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class LocalReplicatedMapStatsImpl
implements LocalReplicatedMapStats,
IdentifiedDataSerializable {
    private final AtomicLong lastAccessTime = new AtomicLong(0L);
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong numberOfOtherOperations = new AtomicLong(0L);
    private final AtomicLong numberOfEvents = new AtomicLong(0L);
    private final AtomicLong numberOfReplicationEvents = new AtomicLong(0L);
    private final AtomicLong getCount = new AtomicLong(0L);
    private final AtomicLong putCount = new AtomicLong(0L);
    private final AtomicLong removeCount = new AtomicLong(0L);
    private final AtomicLong totalGetLatencies = new AtomicLong(0L);
    private final AtomicLong totalPutLatencies = new AtomicLong(0L);
    private final AtomicLong totalRemoveLatencies = new AtomicLong(0L);
    private final AtomicLong maxGetLatency = new AtomicLong(0L);
    private final AtomicLong maxPutLatency = new AtomicLong(0L);
    private final AtomicLong maxRemoveLatency = new AtomicLong(0L);
    private long ownedEntryCount;
    private long creationTime = Clock.currentTimeMillis();

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.getCount.get());
        out.writeLong(this.putCount.get());
        out.writeLong(this.removeCount.get());
        out.writeLong(this.numberOfOtherOperations.get());
        out.writeLong(this.numberOfEvents.get());
        out.writeLong(this.lastAccessTime.get());
        out.writeLong(this.lastUpdateTime.get());
        out.writeLong(this.hits.get());
        out.writeLong(this.ownedEntryCount);
        out.writeLong(this.creationTime);
        out.writeLong(this.totalGetLatencies.get());
        out.writeLong(this.totalPutLatencies.get());
        out.writeLong(this.totalRemoveLatencies.get());
        out.writeLong(this.maxGetLatency.get());
        out.writeLong(this.maxPutLatency.get());
        out.writeLong(this.maxRemoveLatency.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.getCount.set(in.readLong());
        this.putCount.set(in.readLong());
        this.removeCount.set(in.readLong());
        this.numberOfOtherOperations.set(in.readLong());
        this.numberOfEvents.set(in.readLong());
        this.lastAccessTime.set(in.readLong());
        this.lastUpdateTime.set(in.readLong());
        this.hits.set(in.readLong());
        this.ownedEntryCount = in.readLong();
        this.creationTime = in.readLong();
        this.totalGetLatencies.set(in.readLong());
        this.totalPutLatencies.set(in.readLong());
        this.totalRemoveLatencies.set(in.readLong());
        this.maxGetLatency.set(in.readLong());
        this.maxPutLatency.set(in.readLong());
        this.maxRemoveLatency.set(in.readLong());
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    @Override
    public long getBackupEntryCount() {
        return 0L;
    }

    public void setBackupEntryCount(long backupEntryCount) {
    }

    @Override
    public int getBackupCount() {
        return 0;
    }

    public void setBackupCount(int backupCount) {
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return 0L;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
    }

    @Override
    public long getBackupEntryMemoryCost() {
        return 0L;
    }

    public void setBackupEntryMemoryCost(long backupEntryMemoryCost) {
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public void setLastAccessTime(long lastAccessTime) {
        long max = Math.max(this.lastAccessTime.get(), lastAccessTime);
        this.lastAccessTime.set(max);
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime.get();
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        long max = Math.max(this.lastUpdateTime.get(), lastUpdateTime);
        this.lastUpdateTime.set(max);
    }

    @Override
    public long getHits() {
        return this.hits.get();
    }

    public void setHits(long hits) {
        this.hits.set(hits);
    }

    @Override
    public long getLockedEntryCount() {
        return 0L;
    }

    public void setLockedEntryCount(long lockedEntryCount) {
    }

    @Override
    public long getDirtyEntryCount() {
        return 0L;
    }

    public void setDirtyEntryCount(long l) {
    }

    @Override
    public long total() {
        return this.putCount.get() + this.getCount.get() + this.removeCount.get() + this.numberOfOtherOperations.get();
    }

    @Override
    public long getPutOperationCount() {
        return this.putCount.get();
    }

    public void incrementPuts(long latency) {
        this.putCount.incrementAndGet();
        this.totalPutLatencies.addAndGet(latency);
        this.maxPutLatency.set(Math.max(this.maxPutLatency.get(), latency));
    }

    @Override
    public long getGetOperationCount() {
        return this.getCount.get();
    }

    public void incrementGets(long latency) {
        this.getCount.incrementAndGet();
        this.totalGetLatencies.addAndGet(latency);
        this.maxGetLatency.set(Math.max(this.maxGetLatency.get(), latency));
    }

    @Override
    public long getRemoveOperationCount() {
        return this.removeCount.get();
    }

    public void incrementRemoves(long latency) {
        this.removeCount.incrementAndGet();
        this.totalRemoveLatencies.addAndGet(latency);
        this.maxRemoveLatency.set(Math.max(this.maxRemoveLatency.get(), latency));
    }

    @Override
    public long getTotalPutLatency() {
        return this.totalPutLatencies.get();
    }

    @Override
    public long getTotalGetLatency() {
        return this.totalGetLatencies.get();
    }

    @Override
    public long getTotalRemoveLatency() {
        return this.totalRemoveLatencies.get();
    }

    @Override
    public long getMaxPutLatency() {
        return this.maxPutLatency.get();
    }

    @Override
    public long getMaxGetLatency() {
        return this.maxGetLatency.get();
    }

    @Override
    public long getMaxRemoveLatency() {
        return this.maxRemoveLatency.get();
    }

    @Override
    public long getOtherOperationCount() {
        return this.numberOfOtherOperations.get();
    }

    public void incrementOtherOperations() {
        this.numberOfOtherOperations.incrementAndGet();
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents.get();
    }

    public void incrementReceivedEvents() {
        this.numberOfEvents.incrementAndGet();
    }

    @Override
    public long getReplicationEventCount() {
        return this.numberOfReplicationEvents.get();
    }

    public void incrementReceivedReplicationEvents() {
        this.numberOfReplicationEvents.incrementAndGet();
    }

    public void setHeapCost(long heapCost) {
    }

    @Override
    public long getHeapCost() {
        return 0L;
    }

    @Override
    public NearCacheStatsImpl getNearCacheStats() {
        throw new UnsupportedOperationException("Replicated map has no Near Cache!");
    }

    public String toString() {
        return "LocalReplicatedMapStatsImpl{lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", hits=" + this.hits + ", numberOfOtherOperations=" + this.numberOfOtherOperations + ", numberOfEvents=" + this.numberOfEvents + ", numberOfReplicationEvents=" + this.numberOfReplicationEvents + ", getCount=" + this.getCount + ", putCount=" + this.putCount + ", removeCount=" + this.removeCount + ", totalGetLatencies=" + this.totalGetLatencies + ", totalPutLatencies=" + this.totalPutLatencies + ", totalRemoveLatencies=" + this.totalRemoveLatencies + ", ownedEntryCount=" + this.ownedEntryCount + ", creationTime=" + this.creationTime + '}';
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 8;
    }
}

