/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketReadable;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataAdapter;
import com.hazelcast.nio.serialization.SerializationContext;
import java.nio.ByteBuffer;

public final class Packet
extends DataAdapter
implements SocketWritable,
SocketReadable {
    public static final byte VERSION = 1;
    public static final int HEADER_OP = 0;
    public static final int HEADER_RESPONSE = 1;
    public static final int HEADER_EVENT = 2;
    public static final int HEADER_WAN_REPLICATION = 3;
    public static final int HEADER_URGENT = 4;
    private static final int ST_VERSION = 11;
    private static final int ST_HEADER = 12;
    private static final int ST_PARTITION = 13;
    private short header;
    private int partitionId;
    private transient Connection conn;

    public Packet(SerializationContext context) {
        super(context);
    }

    public Packet(Data value, SerializationContext context) {
        this(value, -1, context);
    }

    public Packet(Data value, int partitionId, SerializationContext context) {
        super(value, context);
        this.partitionId = partitionId;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void setHeader(int bit) {
        this.header = (short)(this.header | 1 << bit);
    }

    public boolean isHeaderSet(int bit) {
        return (this.header & 1 << bit) != 0;
    }

    public short getHeader() {
        return this.header;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isUrgent() {
        return this.isHeaderSet(4);
    }

    @Override
    public boolean writeTo(ByteBuffer destination) {
        if (!this.isStatusSet(11)) {
            if (!destination.hasRemaining()) {
                return false;
            }
            destination.put((byte)1);
            this.setStatus(11);
        }
        if (!this.isStatusSet(12)) {
            if (destination.remaining() < 2) {
                return false;
            }
            destination.putShort(this.header);
            this.setStatus(12);
        }
        if (!this.isStatusSet(13)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.partitionId);
            this.setStatus(13);
        }
        return super.writeTo(destination);
    }

    @Override
    public boolean readFrom(ByteBuffer source) {
        if (!this.isStatusSet(11)) {
            if (!source.hasRemaining()) {
                return false;
            }
            byte version = source.get();
            this.setStatus(11);
            if (1 != version) {
                throw new IllegalArgumentException("Packet versions are not matching! This -> 1, Incoming -> " + version);
            }
        }
        if (!this.isStatusSet(12)) {
            if (source.remaining() < 2) {
                return false;
            }
            this.header = source.getShort();
            this.setStatus(12);
        }
        if (!this.isStatusSet(13)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.partitionId = source.getInt();
            this.setStatus(13);
        }
        return super.readFrom(source);
    }

    public int size() {
        return (this.data != null ? this.data.totalSize() : 0) + 7;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Packet{");
        sb.append("header=").append(this.header);
        sb.append(", isResponse=").append(this.isHeaderSet(1));
        sb.append(", isOperation=").append(this.isHeaderSet(0));
        sb.append(", isEvent=").append(this.isHeaderSet(2));
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", conn=").append(this.conn);
        sb.append('}');
        return sb.toString();
    }
}

