/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.BinaryClassDefinition;
import com.hazelcast.nio.serialization.BinaryClassDefinitionProxy;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationContextAware;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;

public final class Data
implements IdentifiedDataSerializable {
    public static final int FACTORY_ID = 0;
    public static final int ID = 0;
    public static final int NO_CLASS_ID = 0;
    int type = -2;
    ClassDefinition classDefinition;
    byte[] buffer;
    int partitionHash;

    public Data() {
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public Data(int type, byte[] bytes) {
        this.type = type;
        this.buffer = bytes;
    }

    public void postConstruct(SerializationContext context) {
        if (this.classDefinition != null && this.classDefinition instanceof BinaryClassDefinitionProxy) {
            try {
                this.classDefinition = ((BinaryClassDefinitionProxy)this.classDefinition).toReal(context);
            }
            catch (IOException e) {
                throw new HazelcastSerializationException(e);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size;
        this.type = in.readInt();
        int classId = in.readInt();
        if (classId != 0) {
            int factoryId = in.readInt();
            int version = in.readInt();
            SerializationContext context = ((SerializationContextAware)((Object)in)).getSerializationContext();
            this.classDefinition = context.lookup(factoryId, classId, version);
            int classDefSize = in.readInt();
            if (this.classDefinition != null) {
                int skipped = in.skipBytes(classDefSize);
                if (skipped != classDefSize) {
                    throw new HazelcastSerializationException("Not able to skip " + classDefSize + " bytes");
                }
            } else {
                byte[] classDefBytes = new byte[classDefSize];
                in.readFully(classDefBytes);
                this.classDefinition = context.createClassDefinition(factoryId, classDefBytes);
            }
        }
        if ((size = in.readInt()) > 0) {
            this.buffer = new byte[size];
            in.readFully(this.buffer);
        }
        this.partitionHash = in.readInt();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.type);
        if (this.classDefinition != null) {
            out.writeInt(this.classDefinition.getClassId());
            out.writeInt(this.classDefinition.getFactoryId());
            out.writeInt(this.classDefinition.getVersion());
            byte[] classDefBytes = ((BinaryClassDefinition)this.classDefinition).getBinary();
            out.writeInt(classDefBytes.length);
            out.write(classDefBytes);
        } else {
            out.writeInt(0);
        }
        int size = this.bufferSize();
        out.writeInt(size);
        if (size > 0) {
            out.write(this.buffer);
        }
        out.writeInt(this.getPartitionHash());
    }

    public int bufferSize() {
        return this.buffer == null ? 0 : this.buffer.length;
    }

    public int totalSize() {
        int total = 0;
        total += 4;
        if (this.classDefinition != null) {
            total += 4;
            total += 4;
            total += 4;
            total += 4;
            byte[] binary = ((BinaryClassDefinition)this.classDefinition).getBinary();
            total += binary != null ? binary.length : 0;
        } else {
            total += 4;
        }
        total += 4;
        total += this.bufferSize();
        return total += 4;
    }

    public int getHeapCost() {
        int total = 0;
        total += 4;
        total += 4;
        total += 16;
        total += this.bufferSize();
        return total += 4;
    }

    public int hashCode() {
        return Data.calculateHash(this.buffer);
    }

    private static int calculateHash(byte[] buffer) {
        if (buffer == null) {
            return 0;
        }
        int prime = 16777619;
        int hash = -2128831035;
        for (int i = buffer.length - 1; i >= 0; --i) {
            hash = (hash ^ buffer[i]) * 16777619;
        }
        return hash;
    }

    public int getPartitionHash() {
        int ph = this.partitionHash;
        if (ph == 0 && this.bufferSize() > 0) {
            ph = this.partitionHash = this.hashCode();
        }
        return ph;
    }

    public int getType() {
        return this.type;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBuffer() {
        return this.buffer;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Data)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Data data = (Data)obj;
        return this.type == data.type && this.bufferSize() == data.bufferSize() && Data.equals(this.buffer, data.buffer);
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        int length = data1.length;
        if (data2.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 0;
    }

    public boolean isPortable() {
        return -1 == this.type;
    }

    public boolean isDataSerializable() {
        return -2 == this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Data{");
        sb.append("type=").append(this.type);
        sb.append(", partitionHash=").append(this.getPartitionHash());
        sb.append(", bufferSize=").append(this.bufferSize());
        sb.append(", totalSize=").append(this.totalSize());
        sb.append('}');
        return sb.toString();
    }
}

