/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UnsortedIndexStore
implements IndexStore {
    private final ConcurrentMap<Comparable, ConcurrentMap<Data, QueryableEntry>> mapRecords = new ConcurrentHashMap<Comparable, ConcurrentMap<Data, QueryableEntry>>(1000);

    @Override
    public void getSubRecordsBetween(MultiResultSet results, Comparable from, Comparable to) {
        int trend = from.compareTo(to);
        if (trend == 0) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(from);
            if (records != null) {
                results.addResultSet(records);
            }
            return;
        }
        if (trend < 0) {
            Comparable oldFrom = from;
            from = to;
            to = oldFrom;
        }
        Set values = this.mapRecords.keySet();
        for (Comparable value : values) {
            ConcurrentMap records;
            if (value.compareTo(from) > 0 || value.compareTo(to) < 0 || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
            results.addResultSet(records);
        }
    }

    @Override
    public void getSubRecords(MultiResultSet results, ComparisonType comparisonType, Comparable searchedValue) {
        Set values = this.mapRecords.keySet();
        for (Comparable value : values) {
            ConcurrentMap records;
            boolean valid;
            int result = value.compareTo(searchedValue);
            switch (comparisonType) {
                case LESSER: {
                    valid = result < 0;
                    break;
                }
                case LESSER_EQUAL: {
                    valid = result <= 0;
                    break;
                }
                case GREATER: {
                    valid = result > 0;
                    break;
                }
                case GREATER_EQUAL: {
                    valid = result >= 0;
                    break;
                }
                case NOT_EQUAL: {
                    valid = result != 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized comparisonType:" + (Object)((Object)comparisonType));
                }
            }
            if (!valid || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
            results.addResultSet(records);
        }
    }

    @Override
    public void newIndex(Comparable newValue, QueryableEntry record) {
        ConcurrentMap existing;
        Data indexKey = record.getIndexKey();
        ConcurrentMap<Data, QueryableEntry> records = (ConcurrentHashMap<Data, QueryableEntry>)this.mapRecords.get(newValue);
        if (records == null && (existing = (ConcurrentMap)this.mapRecords.putIfAbsent(newValue, records = new ConcurrentHashMap<Data, QueryableEntry>())) != null) {
            records = existing;
        }
        records.put(indexKey, record);
    }

    @Override
    public ConcurrentMap<Data, QueryableEntry> getRecordMap(Comparable indexValue) {
        return (ConcurrentMap)this.mapRecords.get(indexValue);
    }

    @Override
    public void removeIndex(Comparable oldValue, Data indexKey) {
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(oldValue);
        if (records != null) {
            records.remove(indexKey);
            if (records.size() == 0) {
                this.mapRecords.remove(oldValue);
            }
        }
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        return new SingleResultSet((ConcurrentMap)this.mapRecords.get(value));
    }

    @Override
    public void getRecords(MultiResultSet results, Set<Comparable> values) {
        for (Comparable value : values) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(records);
        }
    }

    @Override
    public void clear() {
        this.mapRecords.clear();
    }

    public String toString() {
        return "UnsortedIndexStore{mapRecords=" + this.mapRecords.size() + '}';
    }
}

