/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.spi.exception.CallTimeoutException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.BasicInvocationFuture;
import com.hazelcast.spi.impl.BasicOperationService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.NormalResponse;
import com.hazelcast.util.ExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

abstract class BasicInvocation
implements ResponseHandler,
Runnable {
    private static final AtomicReferenceFieldUpdater RESPONSE_RECEIVED_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BasicInvocation.class, Boolean.class, "responseReceived");
    static final Object NULL_RESPONSE = new InternalResponse("Invocation::NULL_RESPONSE");
    static final Object RETRY_RESPONSE = new InternalResponse("Invocation::RETRY_RESPONSE");
    static final Object WAIT_RESPONSE = new InternalResponse("Invocation::WAIT_RESPONSE");
    static final Object TIMEOUT_RESPONSE = new InternalResponse("Invocation::TIMEOUT_RESPONSE");
    static final Object INTERRUPTED_RESPONSE = new InternalResponse("Invocation::INTERRUPTED_RESPONSE");
    private static final long MIN_TIMEOUT = 10000L;
    protected final long callTimeout;
    protected final NodeEngineImpl nodeEngine;
    protected final String serviceName;
    protected final Operation op;
    protected final int partitionId;
    protected final int replicaIndex;
    protected final int tryCount;
    protected final long tryPauseMillis;
    protected final ILogger logger;
    private final BasicInvocationFuture invocationFuture;
    private volatile Boolean responseReceived = Boolean.FALSE;
    private volatile int invokeCount = 0;
    boolean remote = false;
    private final String executorName;
    final boolean resultDeserialized;
    private Address invTarget;
    private MemberImpl invTargetMember;
    volatile int backupsCompleted;
    volatile NormalResponse potentialResponse;
    volatile int backupsExpected;

    BasicInvocation(NodeEngineImpl nodeEngine, String serviceName, Operation op, int partitionId, int replicaIndex, int tryCount, long tryPauseMillis, long callTimeout, Callback<Object> callback, String executorName, boolean resultDeserialized) {
        this.logger = nodeEngine.getLogger(BasicInvocation.class);
        this.nodeEngine = nodeEngine;
        this.serviceName = serviceName;
        this.op = op;
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.tryCount = tryCount;
        this.tryPauseMillis = tryPauseMillis;
        this.callTimeout = this.getCallTimeout(callTimeout);
        this.invocationFuture = new BasicInvocationFuture<Object>(this, callback);
        this.executorName = executorName;
        this.resultDeserialized = resultDeserialized;
    }

    abstract ExceptionAction onException(Throwable var1);

    public String getServiceName() {
        return this.serviceName;
    }

    InternalPartition getPartition() {
        return this.nodeEngine.getPartitionService().getPartition(this.partitionId);
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    ExecutorService getAsyncExecutor() {
        return this.nodeEngine.getExecutionService().getExecutor("hz:async");
    }

    private long getCallTimeout(long callTimeout) {
        long waitTimeoutMillis;
        if (callTimeout > 0L) {
            return callTimeout;
        }
        BasicOperationService operationService = (BasicOperationService)this.nodeEngine.operationService;
        long defaultCallTimeout = operationService.getDefaultCallTimeout();
        if (this.op instanceof WaitSupport && (waitTimeoutMillis = this.op.getWaitTimeout()) > 0L && waitTimeoutMillis < Long.MAX_VALUE) {
            long max = Math.max(waitTimeoutMillis, 10000L);
            return Math.min(max, defaultCallTimeout);
        }
        return defaultCallTimeout;
    }

    public final BasicInvocationFuture invoke() {
        if (this.invokeCount > 0) {
            throw new IllegalStateException("An invocation can not be invoked more than once!");
        }
        if (this.op.getCallId() != 0L) {
            throw new IllegalStateException("An operation[" + this.op + "] can not be used for multiple invocations!");
        }
        try {
            OperationAccessor.setCallTimeout(this.op, this.callTimeout);
            OperationAccessor.setCallerAddress(this.op, this.nodeEngine.getThisAddress());
            this.op.setNodeEngine(this.nodeEngine).setServiceName(this.serviceName).setPartitionId(this.partitionId).setReplicaIndex(this.replicaIndex).setExecutorName(this.executorName);
            if (this.op.getCallerUuid() == null) {
                this.op.setCallerUuid(this.nodeEngine.getLocalMember().getUuid());
            }
            BasicOperationService operationService = (BasicOperationService)this.nodeEngine.operationService;
            if (!operationService.scheduler.isInvocationAllowedFromCurrentThread(this.op) && !OperationAccessor.isMigrationOperation(this.op)) {
                throw new IllegalThreadStateException(Thread.currentThread() + " cannot make remote call: " + this.op);
            }
            this.doInvoke();
        }
        catch (Exception e) {
            if (e instanceof RetryableException) {
                this.notify(e);
            }
            throw ExceptionUtil.rethrow(e);
        }
        return this.invocationFuture;
    }

    private void resetAndReInvoke() {
        this.invokeCount = 0;
        this.potentialResponse = null;
        this.backupsExpected = -1;
        this.doInvoke();
    }

    private void doInvoke() {
        if (!this.nodeEngine.isActive()) {
            this.remote = false;
            this.notify(new HazelcastInstanceNotActiveException());
            return;
        }
        this.invTarget = this.getTarget();
        ++this.invokeCount;
        Address thisAddress = this.nodeEngine.getThisAddress();
        if (this.invTarget == null) {
            this.remote = false;
            if (this.nodeEngine.isActive()) {
                this.notify(new WrongTargetException(thisAddress, null, this.partitionId, this.replicaIndex, this.op.getClass().getName(), this.serviceName));
            } else {
                this.notify(new HazelcastInstanceNotActiveException());
            }
            return;
        }
        this.invTargetMember = this.nodeEngine.getClusterService().getMember(this.invTarget);
        if (!OperationAccessor.isJoinOperation(this.op) && this.invTargetMember == null) {
            this.notify(new TargetNotMemberException(this.invTarget, this.partitionId, this.op.getClass().getName(), this.serviceName));
            return;
        }
        if (this.op.getPartitionId() != this.partitionId) {
            this.notify(new IllegalStateException("Partition id of operation: " + this.op.getPartitionId() + " is not equal to the partition id of invocation: " + this.partitionId));
            return;
        }
        if (this.op.getReplicaIndex() != this.replicaIndex) {
            this.notify(new IllegalStateException("Replica index of operation: " + this.op.getReplicaIndex() + " is not equal to the replica index of invocation: " + this.replicaIndex));
            return;
        }
        BasicOperationService operationService = (BasicOperationService)this.nodeEngine.operationService;
        OperationAccessor.setInvocationTime(this.op, this.nodeEngine.getClusterTime());
        boolean bl = this.remote = !thisAddress.equals(this.invTarget);
        if (this.remote) {
            long callId = operationService.registerInvocation(this);
            boolean sent = operationService.send(this.op, this.invTarget);
            if (!sent) {
                operationService.deregisterInvocation(callId);
                this.notify(new RetryableIOException("Packet not send to -> " + this.invTarget));
            }
        } else {
            if (this.op instanceof BackupAwareOperation) {
                operationService.registerInvocation(this);
            }
            this.responseReceived = Boolean.FALSE;
            this.op.setResponseHandler(this);
            if (operationService.scheduler.isAllowedToRunInCurrentThread(this.op)) {
                operationService.runOperationOnCallingThread(this.op);
            } else {
                operationService.executeOperation(this.op);
            }
        }
    }

    private static Throwable getError(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Throwable) {
            return (Throwable)obj;
        }
        if (!(obj instanceof NormalResponse)) {
            return null;
        }
        NormalResponse response = (NormalResponse)obj;
        if (!(response.getValue() instanceof Throwable)) {
            return null;
        }
        return (Throwable)response.getValue();
    }

    @Override
    public void sendResponse(Object obj) {
        if (!RESPONSE_RECEIVED_FIELD_UPDATER.compareAndSet(this, Boolean.FALSE, Boolean.TRUE)) {
            throw new ResponseAlreadySentException("NormalResponse already responseReceived for callback: " + this + ", current-response: : " + obj);
        }
        this.notify(obj);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public boolean isCallTarget(MemberImpl leftMember) {
        if (this.invTargetMember == null) {
            return leftMember.getAddress().equals(this.invTarget);
        }
        return leftMember.getUuid().equals(this.invTargetMember.getUuid());
    }

    public void notify(Object obj) {
        NormalResponse resp;
        Object response = this.resolveResponse(obj);
        if (response == RETRY_RESPONSE) {
            this.handleRetryResponse();
            return;
        }
        if (response == WAIT_RESPONSE) {
            this.handleWaitResponse();
            return;
        }
        if (response instanceof NormalResponse && this.op instanceof BackupAwareOperation && (resp = (NormalResponse)response).getBackupCount() > 0) {
            this.waitForBackups(resp.getBackupCount(), 5L, TimeUnit.SECONDS, resp);
            return;
        }
        this.invocationFuture.set(response);
    }

    private void handleWaitResponse() {
        this.invocationFuture.set(WAIT_RESPONSE);
    }

    private void handleRetryResponse() {
        if (this.invocationFuture.interrupted) {
            this.invocationFuture.set(INTERRUPTED_RESPONSE);
        } else {
            this.invocationFuture.set(WAIT_RESPONSE);
            ExecutionService ex = this.nodeEngine.getExecutionService();
            if (this.invokeCount < 5) {
                this.getAsyncExecutor().execute(this);
            } else {
                ex.schedule("hz:async", this, this.tryPauseMillis, TimeUnit.MILLISECONDS);
            }
        }
    }

    private Object resolveResponse(Object obj) {
        if (obj == null) {
            return NULL_RESPONSE;
        }
        Throwable error = BasicInvocation.getError(obj);
        if (error == null) {
            return obj;
        }
        if (error instanceof CallTimeoutException) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Call timed-out during wait-notify phase, retrying call: " + this.toString());
            }
            if (this.op instanceof WaitSupport) {
                long waitTimeout = this.op.getWaitTimeout();
                this.op.setWaitTimeout(waitTimeout -= this.callTimeout);
            }
            --this.invokeCount;
            return RETRY_RESPONSE;
        }
        ExceptionAction action = this.onException(error);
        int localInvokeCount = this.invokeCount;
        if (action == ExceptionAction.RETRY_INVOCATION && localInvokeCount < this.tryCount) {
            if (localInvokeCount > 99 && localInvokeCount % 10 == 0) {
                this.logger.warning("Retrying invocation: " + this.toString() + ", Reason: " + error);
            }
            return RETRY_RESPONSE;
        }
        if (action == ExceptionAction.CONTINUE_WAIT) {
            return WAIT_RESPONSE;
        }
        return error;
    }

    protected abstract Address getTarget();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicInvocation");
        sb.append("{ serviceName='").append(this.serviceName).append('\'');
        sb.append(", op=").append(this.op);
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", replicaIndex=").append(this.replicaIndex);
        sb.append(", tryCount=").append(this.tryCount);
        sb.append(", tryPauseMillis=").append(this.tryPauseMillis);
        sb.append(", invokeCount=").append(this.invokeCount);
        sb.append(", callTimeout=").append(this.callTimeout);
        sb.append(", target=").append(this.invTarget);
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public void signalOneBackupComplete() {
        BasicInvocation basicInvocation = this;
        synchronized (basicInvocation) {
            ++this.backupsCompleted;
            if (this.backupsExpected == -1) {
                return;
            }
            if (this.backupsExpected != this.backupsCompleted) {
                return;
            }
            if (this.potentialResponse != null) {
                this.invocationFuture.set(this.potentialResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBackups(int backupCount, long timeout, TimeUnit unit, NormalResponse response) {
        BasicInvocation basicInvocation = this;
        synchronized (basicInvocation) {
            this.backupsExpected = backupCount;
            if (this.backupsCompleted == this.backupsExpected) {
                this.invocationFuture.set(response);
                return;
            }
            this.potentialResponse = response;
        }
        this.nodeEngine.getExecutionService().schedule("hz:async", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BasicInvocation basicInvocation = BasicInvocation.this;
                synchronized (basicInvocation) {
                    if (BasicInvocation.this.backupsExpected == BasicInvocation.this.backupsCompleted) {
                        return;
                    }
                }
                if (BasicInvocation.this.nodeEngine.getClusterService().getMember(BasicInvocation.this.invTarget) != null) {
                    basicInvocation = BasicInvocation.this;
                    synchronized (basicInvocation) {
                        if (BasicInvocation.this.potentialResponse != null) {
                            BasicInvocation.this.invocationFuture.set(BasicInvocation.this.potentialResponse);
                            BasicInvocation.this.potentialResponse = null;
                        }
                    }
                    return;
                }
                BasicInvocation.this.resetAndReInvoke();
            }
        }, timeout, unit);
    }

    @Override
    public void run() {
        this.doInvoke();
    }

    static class InternalResponse {
        private String toString;

        private InternalResponse(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

