/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CachedExecutorServiceDelegate;
import com.hazelcast.util.executor.ExecutorType;
import com.hazelcast.util.executor.ManagedExecutorService;
import com.hazelcast.util.executor.NamedThreadPoolExecutor;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ExecutionServiceImpl
implements ExecutionService {
    private final NodeEngineImpl nodeEngine;
    private final ExecutorService cachedExecutorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ScheduledExecutorService defaultScheduledExecutorServiceDelegate;
    private final ILogger logger;
    private final CompletableFutureTask completableFutureTask;
    private final ConcurrentMap<String, ManagedExecutorService> executors = new ConcurrentHashMap<String, ManagedExecutorService>();
    private final ConstructorFunction<String, ManagedExecutorService> constructor = new ConstructorFunction<String, ManagedExecutorService>(){

        @Override
        public ManagedExecutorService createNew(String name) {
            ExecutorConfig cfg = ExecutionServiceImpl.this.nodeEngine.getConfig().findExecutorConfig(name);
            int queueCapacity = cfg.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : cfg.getQueueCapacity();
            return ExecutionServiceImpl.this.createExecutor(name, cfg.getPoolSize(), queueCapacity, ExecutorType.CACHED);
        }
    };

    public ExecutionServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        Node node = nodeEngine.getNode();
        this.logger = node.getLogger(ExecutionService.class.getName());
        ClassLoader classLoader = node.getConfigClassLoader();
        PoolExecutorThreadFactory threadFactory = new PoolExecutorThreadFactory(node.threadGroup, node.getThreadPoolNamePrefix("cached"), classLoader);
        this.cachedExecutorService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (ExecutionServiceImpl.this.logger.isFinestEnabled()) {
                    ExecutionServiceImpl.this.logger.finest("Node is shutting down; discarding the task: " + r);
                }
            }
        });
        String scheduledThreadName = node.getThreadNamePrefix("scheduled");
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new SingleExecutorThreadFactory(node.threadGroup, classLoader, scheduledThreadName));
        this.enableRemoveOnCancelIfAvailable();
        int coreSize = Runtime.getRuntime().availableProcessors();
        this.register("hz:system", coreSize, Integer.MAX_VALUE, ExecutorType.CACHED);
        this.register("hz:scheduled", coreSize * 5, coreSize * 100000, ExecutorType.CACHED);
        this.defaultScheduledExecutorServiceDelegate = this.getScheduledExecutor("hz:scheduled");
        this.completableFutureTask = new CompletableFutureTask();
        this.scheduleWithFixedDelay(this.completableFutureTask, 1000L, 100L, TimeUnit.MILLISECONDS);
    }

    private void enableRemoveOnCancelIfAvailable() {
        try {
            Method m = this.scheduledExecutorService.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
            m.invoke((Object)this.scheduledExecutorService, true);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (InvocationTargetException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public ManagedExecutorService register(String name, int poolSize, int queueCapacity, ExecutorType type) {
        ManagedExecutorService executor;
        ExecutorConfig cfg = this.nodeEngine.getConfig().getExecutorConfigs().get(name);
        if (cfg != null) {
            poolSize = cfg.getPoolSize();
            int n = queueCapacity = cfg.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : cfg.getQueueCapacity();
        }
        if (this.executors.putIfAbsent(name, executor = this.createExecutor(name, poolSize, queueCapacity, type)) != null) {
            throw new IllegalArgumentException("ExecutorService['" + name + "'] already exists!");
        }
        return executor;
    }

    private ManagedExecutorService createExecutor(String name, int poolSize, int queueCapacity, ExecutorType type) {
        ManagedExecutorService executor;
        if (type == ExecutorType.CACHED) {
            executor = new CachedExecutorServiceDelegate(this.nodeEngine, name, this.cachedExecutorService, poolSize, queueCapacity);
        } else if (type == ExecutorType.CONCRETE) {
            Node node = this.nodeEngine.getNode();
            String internalName = name.startsWith("hz:") ? name.substring(3) : name;
            NamedThreadPoolExecutor pool = new NamedThreadPoolExecutor(name, poolSize, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), new PoolExecutorThreadFactory(node.threadGroup, node.getThreadPoolNamePrefix(internalName), node.getConfigClassLoader()));
            pool.allowCoreThreadTimeOut(true);
            executor = pool;
        } else {
            throw new IllegalArgumentException("Unknown executor type: " + (Object)((Object)type));
        }
        return executor;
    }

    @Override
    public ManagedExecutorService getExecutor(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.executors, name, this.constructor);
    }

    @Override
    public <V> ICompletableFuture<V> asCompletableFuture(Future<V> future) {
        if (future == null) {
            throw new IllegalArgumentException("future must not be null");
        }
        if (future instanceof ICompletableFuture) {
            return (ICompletableFuture)future;
        }
        return this.registerCompletableFuture(future);
    }

    @Override
    public void execute(String name, Runnable command) {
        this.getExecutor(name).execute(command);
    }

    @Override
    public Future<?> submit(String name, Runnable task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public <T> Future<T> submit(String name, Callable<T> task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.defaultScheduledExecutorServiceDelegate.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(String name, Runnable command, long delay, TimeUnit unit) {
        return this.getScheduledExecutor(name).schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.defaultScheduledExecutorServiceDelegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutor(name).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.defaultScheduledExecutorServiceDelegate.scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutor(name).scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledExecutorService getDefaultScheduledExecutor() {
        return this.defaultScheduledExecutorServiceDelegate;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor(String name) {
        return new ScheduledExecutorServiceDelegate(this.scheduledExecutorService, this.getExecutor(name));
    }

    @PrivateApi
    void shutdown() {
        this.logger.finest("Stopping executors...");
        this.cachedExecutorService.shutdown();
        this.scheduledExecutorService.shutdownNow();
        try {
            this.cachedExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.finest(e);
        }
        for (ManagedExecutorService executorService : this.executors.values()) {
            executorService.shutdown();
        }
        this.executors.clear();
    }

    @Override
    public void shutdownExecutor(String name) {
        ExecutorService ex = (ExecutorService)this.executors.remove(name);
        if (ex != null) {
            ex.shutdown();
        }
    }

    private <V> ICompletableFuture<V> registerCompletableFuture(Future<V> future) {
        CompletableFutureEntry entry = new CompletableFutureEntry(future, this.nodeEngine, this.completableFutureTask);
        this.completableFutureTask.registerCompletableFutureEntry(entry);
        return entry.completableFuture;
    }

    private static class ScheduledTaskRunner
    implements Runnable {
        private final Executor executor;
        private final Runnable runnable;

        public ScheduledTaskRunner(Runnable runnable, Executor executor) {
            this.executor = executor;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.executor.execute(this.runnable);
            }
            catch (Throwable t) {
                ExceptionUtil.sneakyThrow(t);
            }
        }
    }

    static class BasicCompletableFuture<V>
    extends AbstractCompletableFuture<V> {
        private final Future<V> future;

        BasicCompletableFuture(Future<V> future, NodeEngine nodeEngine) {
            super(nodeEngine, nodeEngine.getLogger(BasicCompletableFuture.class));
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            boolean done = this.future.isDone();
            if (done && !super.isDone()) {
                this.forceSetResult();
                return true;
            }
            return done || super.isDone();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            V result = this.future.get(timeout, unit);
            if (!super.isDone()) {
                this.setResult(result);
            }
            return result;
        }

        private void forceSetResult() {
            Object result;
            try {
                result = this.future.get();
            }
            catch (Throwable t) {
                result = t;
            }
            this.setResult(result);
        }
    }

    private static class ScheduledExecutorServiceDelegate
    implements ScheduledExecutorService {
        private final ScheduledExecutorService scheduledExecutorService;
        private final ExecutorService executor;

        private ScheduledExecutorServiceDelegate(ScheduledExecutorService scheduledExecutorService, ExecutorService executor) {
            this.scheduledExecutorService = scheduledExecutorService;
            this.executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.executor.submit(task);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.scheduledExecutorService.schedule(new ScheduledTaskRunner(command, this.executor), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.scheduledExecutorService.scheduleAtFixedRate(new ScheduledTaskRunner(command, this.executor), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.scheduledExecutorService.scheduleWithFixedDelay(new ScheduledTaskRunner(command, this.executor), initialDelay, delay, unit);
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }

    static class CompletableFutureEntry<V> {
        private final BasicCompletableFuture<V> completableFuture;
        private final CompletableFutureTask completableFutureTask;

        private CompletableFutureEntry(Future<V> future, NodeEngine nodeEngine, CompletableFutureTask completableFutureTask) {
            this.completableFutureTask = completableFutureTask;
            this.completableFuture = new BasicCompletableFuture<V>(future, nodeEngine);
        }

        private boolean processState() {
            if (this.completableFuture.isDone()) {
                Throwable result;
                try {
                    result = ((BasicCompletableFuture)this.completableFuture).future.get();
                }
                catch (Throwable t) {
                    result = t;
                }
                this.completableFuture.setResult(result);
                return true;
            }
            return false;
        }
    }

    private static class CompletableFutureTask
    implements Runnable {
        private final List<CompletableFutureEntry> entries = new ArrayList<CompletableFutureEntry>();
        private final Lock entriesLock = new ReentrantLock();

        private CompletableFutureTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> void registerCompletableFutureEntry(CompletableFutureEntry<V> entry) {
            this.entriesLock.lock();
            try {
                this.entries.add(entry);
            }
            finally {
                this.entriesLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompletableFutureEntry[] copy;
            if (this.entries.isEmpty()) {
                return;
            }
            this.entriesLock.lock();
            try {
                copy = new CompletableFutureEntry[this.entries.size()];
                copy = this.entries.toArray(copy);
            }
            finally {
                this.entriesLock.unlock();
            }
            ArrayList<CompletableFutureEntry> removes = null;
            for (CompletableFutureEntry entry : copy) {
                if (!entry.processState()) continue;
                if (removes == null) {
                    removes = new ArrayList<CompletableFutureEntry>(copy.length / 2);
                }
                removes.add(entry);
            }
            if (removes != null && !removes.isEmpty()) {
                this.entriesLock.lock();
                try {
                    for (int i = 0; i < removes.size(); ++i) {
                        this.entries.remove(removes.get(i));
                    }
                }
                finally {
                    this.entriesLock.unlock();
                }
            }
        }
    }
}

