/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlClientConfigBuilder
extends AbstractXmlConfigHelper {
    private static final ILogger LOGGER = Logger.getLogger(XmlClientConfigBuilder.class);
    private static final int DEFAULT_VALUE = 5;
    private ClientConfig clientConfig;
    private InputStream in;

    public XmlClientConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig(resource);
        if (url == null) {
            throw new IllegalArgumentException("Could not load " + resource);
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null!");
        }
        this.in = new FileInputStream(file);
    }

    public XmlClientConfigBuilder(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(InputStream in) {
        this.in = in;
    }

    public XmlClientConfigBuilder() {
        try {
            if (this.loadFromSystemProperty()) {
                return;
            }
            if (this.loadFromWorkingDirectory()) {
                return;
            }
            if (this.loadClientHazelcastXmlFromClasspath()) {
                return;
            }
            this.loadDefaultConfigurationFromClasspath();
        }
        catch (RuntimeException e) {
            throw new HazelcastException("Failed to load ClientConfig", e);
        }
    }

    private void loadDefaultConfigurationFromClasspath() {
        LOGGER.info("Loading 'hazelcast-client-default.xml' from classpath.");
        this.in = Config.class.getClassLoader().getResourceAsStream("hazelcast-client-default.xml");
        if (this.in == null) {
            throw new HazelcastException("Could not load 'hazelcast-client-default.xml' from classpath");
        }
    }

    private boolean loadClientHazelcastXmlFromClasspath() {
        URL url = Config.class.getClassLoader().getResource("hazelcast-client.xml");
        if (url == null) {
            LOGGER.finest("Could not find 'hazelcast-client.xml' in classpath.");
            return false;
        }
        LOGGER.info("Loading 'hazelcast-client.xml' from classpath.");
        this.in = Config.class.getClassLoader().getResourceAsStream("hazelcast-client.xml");
        if (this.in == null) {
            throw new HazelcastException("Could not load 'hazelcast-client.xml' from classpath");
        }
        return true;
    }

    private boolean loadFromWorkingDirectory() {
        File file = new File("hazelcast-client.xml");
        if (!file.exists()) {
            LOGGER.finest("Could not find 'hazelcast-client.xml' in working directory.");
            return false;
        }
        LOGGER.info("Loading 'hazelcast-client.xml' from working directory.");
        try {
            this.in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException("Failed to open file: " + file.getAbsolutePath(), e);
        }
        return true;
    }

    private boolean loadFromSystemProperty() {
        String configSystemProperty = System.getProperty("hazelcast.client.config");
        if (configSystemProperty == null) {
            LOGGER.finest("Could not 'hazelcast.client.config' System property");
            return false;
        }
        LOGGER.info("Loading configuration " + configSystemProperty + " from System property 'hazelcast.client.config'");
        if (configSystemProperty.startsWith("classpath:")) {
            this.loadSystemPropertyClassPathResource(configSystemProperty);
        } else {
            this.loadSystemPropertyFileResource(configSystemProperty);
        }
        return true;
    }

    private void loadSystemPropertyFileResource(String configSystemProperty) {
        File configurationFile = new File(configSystemProperty);
        LOGGER.info("Using configuration file at " + configurationFile.getAbsolutePath());
        if (!configurationFile.exists()) {
            String msg = "Config file at '" + configurationFile.getAbsolutePath() + "' doesn't exist.";
            throw new HazelcastException(msg);
        }
        try {
            this.in = new FileInputStream(configurationFile);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException("Failed to open file: " + configurationFile.getAbsolutePath(), e);
        }
    }

    private void loadSystemPropertyClassPathResource(String configSystemProperty) {
        String resource = configSystemProperty.substring("classpath:".length());
        LOGGER.info("Using classpath resource at " + resource);
        if (resource.isEmpty()) {
            throw new HazelcastException("classpath resource can't be empty");
        }
        this.in = Config.class.getClassLoader().getResourceAsStream(resource);
        if (this.in == null) {
            throw new HazelcastException("Could not load classpath resource: " + resource);
        }
    }

    public ClientConfig build() {
        return this.build(Thread.currentThread().getContextClassLoader());
    }

    public ClientConfig build(ClassLoader classLoader) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setClassLoader(classLoader);
        try {
            this.parse(clientConfig);
            ClientConfig clientConfig2 = clientConfig;
            return clientConfig2;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            IOUtil.closeResource(this.in);
        }
    }

    private void parse(ClientConfig clientConfig) throws Exception {
        Document doc;
        this.clientConfig = clientConfig;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        try {
            doc = builder.parse(this.in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not parse configuration file, giving up.");
        }
        Element element = doc.getDocumentElement();
        try {
            element.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.handleConfig(element);
    }

    private void handleConfig(Element docElement) throws Exception {
        for (Node node : new AbstractXmlConfigHelper.IterableNodeList(docElement.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(node.getNodeName());
            if ("security".equals(nodeName)) {
                this.handleSecurity(node);
                continue;
            }
            if ("proxy-factories".equals(nodeName)) {
                this.handleProxyFactories(node);
                continue;
            }
            if ("properties".equals(nodeName)) {
                this.fillProperties(node, this.clientConfig.getProperties());
                continue;
            }
            if ("serialization".equals(nodeName)) {
                this.handleSerialization(node);
                continue;
            }
            if ("group".equals(nodeName)) {
                this.handleGroup(node);
                continue;
            }
            if ("listeners".equals(nodeName)) {
                this.handleListeners(node);
                continue;
            }
            if ("network".equals(nodeName)) {
                this.handleNetwork(node);
                continue;
            }
            if ("load-balancer".equals(nodeName)) {
                this.handleLoadBalancer(node);
                continue;
            }
            if ("near-cache".equals(nodeName)) {
                this.handleNearCache(node);
                continue;
            }
            if (!"executor-pool-size".equals(nodeName)) continue;
            int poolSize = Integer.parseInt(this.getTextContent(node));
            this.clientConfig.setExecutorPoolSize(poolSize);
        }
    }

    private void handleNearCache(Node node) {
        String name = this.getAttribute(node, "name");
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(child);
            if ("max-size".equals(nodeName)) {
                nearCacheConfig.setMaxSize(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                nearCacheConfig.setTimeToLiveSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                nearCacheConfig.setMaxIdleSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                nearCacheConfig.setEvictionPolicy(this.getTextContent(child));
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                nearCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(this.getTextContent(child)));
                continue;
            }
            if ("invalidate-on-change".equals(nodeName)) {
                nearCacheConfig.setInvalidateOnChange(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (!"cache-local-entries".equals(nodeName)) continue;
            nearCacheConfig.setCacheLocalEntries(Boolean.parseBoolean(this.getTextContent(child)));
        }
        this.clientConfig.addNearCacheConfig(name, nearCacheConfig);
    }

    private void handleLoadBalancer(Node node) {
        String type = this.getAttribute(node, "type");
        if ("random".equals(type)) {
            this.clientConfig.setLoadBalancer(new RandomLB());
        } else if ("round-robin".equals(type)) {
            this.clientConfig.setLoadBalancer(new RoundRobinLB());
        }
    }

    private void handleNetwork(Node node) {
        ClientNetworkConfig clientNetworkConfig = new ClientNetworkConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(child);
            if ("cluster-members".equals(nodeName)) {
                this.handleClusterMembers(child, clientNetworkConfig);
                continue;
            }
            if ("smart-routing".equals(nodeName)) {
                clientNetworkConfig.setSmartRouting(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("redo-operation".equals(nodeName)) {
                clientNetworkConfig.setRedoOperation(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("connection-timeout".equals(nodeName)) {
                clientNetworkConfig.setConnectionTimeout(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-period".equals(nodeName)) {
                clientNetworkConfig.setConnectionAttemptPeriod(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-limit".equals(nodeName)) {
                clientNetworkConfig.setConnectionAttemptLimit(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("socket-options".equals(nodeName)) {
                this.handleSocketOptions(child, clientNetworkConfig);
                continue;
            }
            if ("socket-interceptor".equals(nodeName)) {
                this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                continue;
            }
            if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(child, clientNetworkConfig);
                continue;
            }
            if (!"aws".equals(nodeName)) continue;
            this.handleAWS(child, clientNetworkConfig);
        }
        this.clientConfig.setNetworkConfig(clientNetworkConfig);
    }

    private void handleAWS(Node node, ClientNetworkConfig clientNetworkConfig) {
        String value;
        NamedNodeMap atts = node.getAttributes();
        ClientAwsConfig clientAwsConfig = new ClientAwsConfig();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                clientAwsConfig.setEnabled(this.checkTrue(value));
                continue;
            }
            if (!att.getNodeName().equals("connection-timeout-seconds")) continue;
            clientAwsConfig.setConnectionTimeoutSeconds(this.getIntegerValue("connection-timeout-seconds", value, 5));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            value = this.getTextContent(n).trim();
            if ("secret-key".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) {
                clientAwsConfig.setSecretKey(value);
                continue;
            }
            if ("access-key".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) {
                clientAwsConfig.setAccessKey(value);
                continue;
            }
            if ("region".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) {
                clientAwsConfig.setRegion(value);
                continue;
            }
            if ("host-header".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) {
                clientAwsConfig.setHostHeader(value);
                continue;
            }
            if ("security-group-name".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) {
                clientAwsConfig.setSecurityGroupName(value);
                continue;
            }
            if ("tag-key".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) {
                clientAwsConfig.setTagKey(value);
                continue;
            }
            if ("tag-value".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) {
                clientAwsConfig.setTagValue(value);
                continue;
            }
            if (!"inside-aws".equals(XmlClientConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            clientAwsConfig.setInsideAws(this.checkTrue(value));
        }
        clientNetworkConfig.setAwsConfig(clientAwsConfig);
    }

    private void handleSSLConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SSLConfig sslConfig = new SSLConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && this.checkTrue(this.getTextContent(enabledNode).trim());
        sslConfig.setEnabled(enabled);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(n.getNodeName());
            if ("factory-class-name".equals(nodeName)) {
                sslConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, sslConfig.getProperties());
        }
        clientNetworkConfig.setSSLConfig(sslConfig);
    }

    private void handleSocketOptions(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketOptions socketOptions = this.clientConfig.getSocketOptions();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(child);
            if ("tcp-no-delay".equals(nodeName)) {
                socketOptions.setTcpNoDelay(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("keep-alive".equals(nodeName)) {
                socketOptions.setKeepAlive(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("reuse-address".equals(nodeName)) {
                socketOptions.setReuseAddress(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("linger-seconds".equals(nodeName)) {
                socketOptions.setLingerSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"buffer-size".equals(nodeName)) continue;
            socketOptions.setBufferSize(Integer.parseInt(this.getTextContent(child)));
        }
        clientNetworkConfig.setSocketOptions(socketOptions);
    }

    private void handleClusterMembers(Node node, ClientNetworkConfig clientNetworkConfig) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"address".equals(this.cleanNodeName(child))) continue;
            clientNetworkConfig.addAddress(this.getTextContent(child));
        }
    }

    private void handleListeners(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"listener".equals(this.cleanNodeName(child))) continue;
            String className = this.getTextContent(child);
            this.clientConfig.addListenerConfig(new ListenerConfig(className));
        }
    }

    private void handleGroup(Node node) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String nodeName = XmlClientConfigBuilder.cleanNodeName(n.getNodeName());
            if ("name".equals(nodeName)) {
                this.clientConfig.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.clientConfig.getGroupConfig().setPassword(value);
        }
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.parseSerialization(node);
        this.clientConfig.setSerializationConfig(serializationConfig);
    }

    private void handleProxyFactories(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"proxy-factory".equals(nodeName)) continue;
            this.handleProxyFactory(child);
        }
    }

    private void handleProxyFactory(Node node) throws Exception {
        String service = this.getAttribute(node, "service");
        String className = this.getAttribute(node, "class-name");
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig(className, service);
        this.clientConfig.addProxyFactoryConfig(proxyFactoryConfig);
    }

    private void handleSocketInterceptorConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        clientNetworkConfig.setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleSecurity(Node node) throws Exception {
        ClientSecurityConfig clientSecurityConfig = new ClientSecurityConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"credentials".equals(nodeName)) continue;
            String className = this.getTextContent(child);
            clientSecurityConfig.setCredentialsClassname(className);
        }
        this.clientConfig.setSecurityConfig(clientSecurityConfig);
    }
}

