/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class AwsAddressTranslator
implements AddressTranslator {
    private static final ILogger LOGGER = Logger.getLogger(AwsAddressTranslator.class);
    private volatile Map<String, String> privateToPublic;
    private final AWSClient awsClient;
    private final boolean isInsideAws;

    public AwsAddressTranslator(ClientAwsConfig awsConfig) {
        this.awsClient = new AWSClient(awsConfig);
        this.isInsideAws = awsConfig.isInsideAws();
    }

    @Override
    public Address translate(Address address) {
        if (this.isInsideAws) {
            return address;
        }
        if (address == null) {
            return null;
        }
        String privateAddress = this.getLookupTable().get(address.getHost());
        if (privateAddress != null) {
            try {
                return new Address(privateAddress, address.getPort());
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        this.refresh();
        privateAddress = this.getLookupTable().get(address.getHost());
        if (privateAddress != null) {
            try {
                return new Address(privateAddress, address.getPort());
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return null;
    }

    private Map<String, String> getLookupTable() {
        Map<String, String> table = this.privateToPublic;
        return table != null ? table : Collections.emptyMap();
    }

    @Override
    public void refresh() {
        try {
            this.privateToPublic = this.awsClient.getAddresses();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Aws addresses are failed to load : " + e.getMessage());
        }
    }
}

