/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class LongRunningTest {
    private static final int STATS_SECONDS = 10;
    private static final Logger LOGGER = Logger.getLogger(LongRunningTest.class.getName());
    private final List<TheNode> nodes = new CopyOnWriteArrayList<TheNode>();
    private final Random random;
    private int nodeIdGen;
    private int starts;
    private int stops;
    private int restarts;
    private int maxNodeSize = 4;
    private int minNodeSize = 2;
    private int nextActionMin = 90;
    private int nextActionMax = 180;

    public LongRunningTest(String[] input) {
        if (input != null && input.length > 0) {
            for (String arg : input) {
                if ((arg = arg.trim()).startsWith("-n1=")) {
                    this.minNodeSize = Integer.parseInt(arg.substring(4));
                    continue;
                }
                if (arg.startsWith("-n2=")) {
                    this.maxNodeSize = Integer.parseInt(arg.substring(4));
                    continue;
                }
                if (arg.startsWith("-i1=")) {
                    this.nextActionMin = Integer.parseInt(arg.substring(4));
                    continue;
                }
                if (!arg.startsWith("-i2=")) continue;
                this.nextActionMax = Integer.parseInt(arg.substring(4));
            }
        }
        this.random = new Random();
    }

    public static void main(String[] args) {
        LongRunningTest t = new LongRunningTest(args);
        t.run();
    }

    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LongRunningTest.this.log("Shutting down " + LongRunningTest.this.nodes.size());
                while (LongRunningTest.this.nodes.size() > 0) {
                    LongRunningTest.this.removeNode();
                }
            }
        });
        this.log("Min node size: " + this.minNodeSize);
        this.log("Max node size: " + this.maxNodeSize);
        for (int i = 0; i < this.minNodeSize; ++i) {
            this.addNode();
        }
        while (!Thread.currentThread().isInterrupted()) {
            if (this.nodes.size() >= this.maxNodeSize) {
                this.removeNode();
            } else if (this.nodes.size() < this.minNodeSize) {
                this.addNode();
            } else {
                int action = this.random(3);
                switch (action) {
                    case 0: {
                        this.removeNode();
                        break;
                    }
                    case 1: {
                        this.addNode();
                        break;
                    }
                    case 2: {
                        this.restartNode();
                        break;
                    }
                }
            }
            try {
                int nextSeconds = this.random(this.nextActionMin, this.nextActionMax);
                this.log("Next Action after " + nextSeconds + " seconds.");
                this.log("members:" + this.nodes.size() + ", starts: " + this.starts + ", stops:" + this.stops + ", restart:" + this.restarts);
                Thread.sleep(nextSeconds * 1000);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    void log(Object obj) {
        LOGGER.info(obj.toString());
    }

    void addNode() {
        ++this.starts;
        int entryCount = this.random(10000);
        int threadCount = this.random(10, 50);
        int valueSizeMax = entryCount < 1000 ? 50000 : 1000;
        int valueSize = this.random(10, valueSizeMax);
        TheNode node = new TheNode(this.nodeIdGen++, entryCount, threadCount, valueSize);
        this.nodes.add(node);
        node.start();
        this.log("Started " + node);
    }

    void restartNode() {
        ++this.restarts;
        this.log("Restarting...");
        this.removeNode();
        try {
            Thread.sleep(this.random(10) * 1000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.addNode();
    }

    void removeNode() {
        ++this.stops;
        TheNode node = this.nodes.remove(this.random(this.nodes.size()));
        node.stop();
        this.log("Stopped " + node);
    }

    int random(int length) {
        return (int)(this.random.nextFloat() * 1.0E7f) % length;
    }

    int random(int from, int to) {
        double diff = to - from;
        return (int)(diff * (double)this.random.nextFloat() + (double)from);
    }

    static {
        System.setProperty("hazelcast.version.check.enabled", "false");
        System.setProperty("hazelcast.socket.bind.any", "false");
        System.setProperty("hazelcast.partition.migration.interval", "0");
    }

    class Stats {
        private AtomicLong mapPuts = new AtomicLong();
        private AtomicLong mapGets = new AtomicLong();
        private AtomicLong mapRemoves = new AtomicLong();

        Stats() {
        }

        public Stats getAndReset() {
            long mapPutsNow = this.mapPuts.getAndSet(0L);
            long mapGetsNow = this.mapGets.getAndSet(0L);
            long mapRemovesNow = this.mapRemoves.getAndSet(0L);
            Stats newOne = new Stats();
            newOne.mapPuts.set(mapPutsNow);
            newOne.mapGets.set(mapGetsNow);
            newOne.mapRemoves.set(mapRemovesNow);
            return newOne;
        }

        public long total() {
            return this.mapPuts.get() + this.mapGets.get() + this.mapRemoves.get();
        }

        public String toString() {
            return "total= " + this.total() + ", puts:" + this.mapPuts.get() + ", gets:" + this.mapGets.get() + ", remove:" + this.mapRemoves.get();
        }
    }

    class TheNode {
        final int entryCount;
        final int threadCount;
        final int valueSize;
        final int nodeId;
        final long createTime;
        final ExecutorService es;
        final ExecutorService esStats;
        final HazelcastInstance hazelcast;
        volatile boolean running = true;

        TheNode(int nodeId, int entryCount, int threadCount, int valueSize) {
            this.entryCount = entryCount;
            this.threadCount = threadCount;
            this.valueSize = valueSize;
            this.nodeId = nodeId;
            this.es = Executors.newFixedThreadPool(threadCount);
            Config cfg = new XmlConfigBuilder().build();
            this.hazelcast = Hazelcast.newHazelcastInstance(cfg);
            this.esStats = Executors.newSingleThreadExecutor();
            this.createTime = System.currentTimeMillis();
        }

        public void stop() {
            try {
                this.running = false;
                this.es.shutdown();
                this.es.awaitTermination(10L, TimeUnit.SECONDS);
                this.esStats.shutdown();
                this.hazelcast.getLifecycleService().shutdown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void start() {
            final Stats stats = new Stats();
            for (int i = 0; i < this.threadCount; ++i) {
                this.es.submit(new Runnable(){

                    @Override
                    public void run() {
                        IMap<String, byte[]> map = TheNode.this.hazelcast.getMap("default");
                        while (TheNode.this.running) {
                            try {
                                int key = (int)(LongRunningTest.this.random.nextFloat() * (float)TheNode.this.entryCount);
                                int operation = LongRunningTest.this.random(10);
                                if (operation < 4) {
                                    map.put(String.valueOf(key), new byte[TheNode.this.valueSize]);
                                    stats.mapPuts.incrementAndGet();
                                    continue;
                                }
                                if (operation < 8) {
                                    map.get(String.valueOf(key));
                                    stats.mapGets.incrementAndGet();
                                    continue;
                                }
                                map.remove(String.valueOf(key));
                                stats.mapRemoves.incrementAndGet();
                            }
                            catch (HazelcastInstanceNotActiveException ignored) {
                                throw new RuntimeException(ignored);
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                });
            }
            this.esStats.submit(new Runnable(){

                @Override
                public void run() {
                    ILogger logger = TheNode.this.hazelcast.getLoggingService().getLogger(TheNode.this.hazelcast.getName());
                    while (TheNode.this.running) {
                        try {
                            Thread.sleep(10000L);
                            int clusterSize = TheNode.this.hazelcast.getCluster().getMembers().size();
                            Stats currentStats = stats.getAndReset();
                            logger.info("Cluster size: " + clusterSize + ", Operations per Second: " + currentStats.total() / 10L);
                        }
                        catch (HazelcastInstanceNotActiveException e) {
                            throw new RuntimeException(e);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }

        public String toString() {
            return "TheNode{nodeId=" + this.nodeId + ", entryCount=" + this.entryCount + ", threadCount=" + this.threadCount + ", valueSize=" + this.valueSize + ", liveSeconds=" + (System.currentTimeMillis() - this.createTime) / 1000L + ", running=" + this.running + '}';
        }
    }
}

