/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.executor.CallableTaskOperation;
import com.hazelcast.executor.CancellableDelegatingFuture;
import com.hazelcast.executor.DistributedExecutorService;
import com.hazelcast.executor.ExecutionCallbackAdapter;
import com.hazelcast.executor.ExecutionCallbackAdapterFactory;
import com.hazelcast.executor.MemberCallableTaskOperation;
import com.hazelcast.executor.RunnableAdapter;
import com.hazelcast.executor.ShutdownOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class ExecutorServiceProxy
extends AbstractDistributedObject<DistributedExecutorService>
implements IExecutorService {
    private static final AtomicIntegerFieldUpdater<ExecutorServiceProxy> CONSECUTIVE_SUBMITS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ExecutorServiceProxy.class, "consecutiveSubmits");
    public static final int SYNC_FREQUENCY = 100;
    private final String name;
    private final Random random = new Random(-System.currentTimeMillis());
    private final int partitionCount;
    private final ILogger logger;
    private volatile int consecutiveSubmits = 0;
    private volatile long lastSubmitTime;

    public ExecutorServiceProxy(String name, NodeEngine nodeEngine, DistributedExecutorService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.logger = nodeEngine.getLogger(ExecutorServiceProxy.class);
    }

    @Override
    public void execute(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.executeOnMember(command, members.get(selectedMember));
    }

    @Override
    public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        this.executeOnMembers(command, members);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        return this.submitToMember(task, members.get(selectedMember));
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        return this.submitToMembers(task, members);
    }

    @Override
    public void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public void execute(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submit(callable);
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(command);
    }

    @Override
    public void executeOnKeyOwner(Runnable command, Object key) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwner(callable, key);
    }

    @Override
    public void executeOnMember(Runnable command, Member member) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMember(callable, member);
    }

    @Override
    public void executeOnMembers(Runnable command, Collection<Member> members) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMembers(callable, members);
    }

    @Override
    public void executeOnAllMembers(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToAllMembers(callable);
    }

    @Override
    public Future<?> submit(Runnable task) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        return this.submit(callable);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        RunnableAdapter<T> callable = this.createRunnableAdapter(task);
        NodeEngine nodeEngine = this.getNodeEngine();
        String uuid = UuidUtil.buildRandomUuidString();
        int partitionId = this.getTaskPartitionId(callable);
        CallableTaskOperation op = new CallableTaskOperation(this.name, uuid, callable);
        InternalCompletableFuture future = this.invoke(partitionId, op);
        boolean sync = this.checkSync();
        if (sync) {
            try {
                future.get();
            }
            catch (Exception exception) {
                this.logger.warning(exception);
            }
            return new CompletedFuture(nodeEngine.getSerializationService(), result, this.getAsyncExecutor());
        }
        return new CancellableDelegatingFuture<T>(future, result, nodeEngine, uuid, partitionId);
    }

    private InternalCompletableFuture invoke(int partitionId, CallableTaskOperation op) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        return operationService.invokeOnPartition("hz:impl:executorService", op, partitionId);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        int partitionId = this.getTaskPartitionId(task);
        return this.submitToPartitionOwner(task, partitionId, false);
    }

    private <T> Future<T> submitToPartitionOwner(Callable<T> task, int partitionId, boolean preventSync) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        String uuid = UuidUtil.buildRandomUuidString();
        boolean sync = !preventSync && this.checkSync();
        CallableTaskOperation op = new CallableTaskOperation(this.name, uuid, task);
        InternalCompletableFuture future = this.invoke(partitionId, op);
        if (sync) {
            Object response;
            try {
                response = future.get();
            }
            catch (Exception e) {
                response = e;
            }
            return new CompletedFuture(nodeEngine.getSerializationService(), response, this.getAsyncExecutor());
        }
        return new CancellableDelegatingFuture((ICompletableFuture)future, nodeEngine, uuid, partitionId);
    }

    private boolean checkSync() {
        boolean sync = false;
        long last = this.lastSubmitTime;
        long now = Clock.currentTimeMillis();
        if (last + 10L < now) {
            CONSECUTIVE_SUBMITS_UPDATER.set(this, 0);
        } else if (CONSECUTIVE_SUBMITS_UPDATER.incrementAndGet(this) % 100 == 0) {
            sync = true;
        }
        this.lastSubmitTime = now;
        return sync;
    }

    private <T> int getTaskPartitionId(Callable<T> task) {
        int partitionId;
        if (task instanceof PartitionAware) {
            Object partitionKey = ((PartitionAware)((Object)task)).getPartitionKey();
            partitionId = this.getNodeEngine().getPartitionService().getPartitionId(partitionKey);
        } else {
            partitionId = this.random.nextInt(this.partitionCount);
        }
        return partitionId;
    }

    @Override
    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.submitToPartitionOwner(task, nodeEngine.getPartitionService().getPartitionId(key), false);
    }

    @Override
    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        String uuid = UuidUtil.buildRandomUuidString();
        Address target = ((MemberImpl)member).getAddress();
        boolean sync = this.checkSync();
        MemberCallableTaskOperation op = new MemberCallableTaskOperation(this.name, uuid, task);
        InternalCompletableFuture future = nodeEngine.getOperationService().invokeOnTarget("hz:impl:executorService", op, target);
        if (sync) {
            Object response;
            try {
                response = future.get();
            }
            catch (Exception e) {
                response = e;
            }
            return new CompletedFuture(nodeEngine.getSerializationService(), response, this.getAsyncExecutor());
        }
        return new CancellableDelegatingFuture(future, nodeEngine, uuid, target);
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        HashMap<Member, Future<T>> futures = new HashMap<Member, Future<T>>(members.size());
        for (Member member : members) {
            futures.put(member, this.submitToMember(task, member));
        }
        return futures;
    }

    @Override
    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.submitToMembers(task, nodeEngine.getClusterService().getMembers());
    }

    @Override
    public void submit(Runnable task, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submit(callable, callback);
    }

    @Override
    public void submitToKeyOwner(Runnable task, Object key, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToKeyOwner(callable, key, callback);
    }

    @Override
    public void submitToMember(Runnable task, Member member, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToMember(callable, member, callback);
    }

    @Override
    public void submitToMembers(Runnable task, Collection<Member> members, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToMembers(callable, members, callback);
    }

    @Override
    public void submitToAllMembers(Runnable task, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToAllMembers(callable, callback);
    }

    private <T> void submitToPartitionOwner(Callable<T> task, ExecutionCallback<T> callback, int partitionId) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        CallableTaskOperation op = new CallableTaskOperation(this.name, null, task);
        OperationService operationService = nodeEngine.getOperationService();
        operationService.createInvocationBuilder("hz:impl:executorService", (Operation)op, partitionId).setCallback(new ExecutionCallbackAdapter(callback)).invoke();
    }

    @Override
    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        int partitionId = this.getTaskPartitionId(task);
        this.submitToPartitionOwner(task, callback, partitionId);
    }

    @Override
    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.submitToPartitionOwner(task, callback, nodeEngine.getPartitionService().getPartitionId(key));
    }

    @Override
    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        MemberCallableTaskOperation op = new MemberCallableTaskOperation(this.name, null, task);
        OperationService operationService = nodeEngine.getOperationService();
        Address address = ((MemberImpl)member).getAddress();
        operationService.createInvocationBuilder("hz:impl:executorService", (Operation)op, address).setCallback(new ExecutionCallbackAdapter(callback)).invoke();
    }

    private String getRejectionMessage() {
        return "ExecutorService[" + this.name + "] is shutdown! In order to create a new ExecutorService with name '" + this.name + "', you need to destroy current ExecutorService first!";
    }

    @Override
    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        ExecutionCallbackAdapterFactory executionCallbackFactory = new ExecutionCallbackAdapterFactory(nodeEngine, members, callback);
        for (Member member : members) {
            this.submitToMember(task, member, executionCallbackFactory.callbackFor(member));
        }
    }

    @Override
    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.submitToMembers(task, nodeEngine.getClusterService().getMembers(), callback);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> callable : tasks) {
            futures.add(this.submit(callable));
        }
        for (Future future : futures) {
            Object value;
            try {
                value = future.get();
            }
            catch (ExecutionException e) {
                value = e;
            }
            result.add(new CompletedFuture(this.getNodeEngine().getSerializationService(), value, this.getAsyncExecutor()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException("unit must not be null");
        }
        if (tasks == null) {
            throw new NullPointerException("tasks must not be null");
        }
        long timeoutNanos = unit.toNanos(timeout);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        boolean done = true;
        try {
            long start;
            for (Callable<T> task : tasks) {
                start = System.nanoTime();
                int partitionId = this.getTaskPartitionId(task);
                futures.add(this.submitToPartitionOwner(task, partitionId, true));
                if ((timeoutNanos -= System.nanoTime() - start) > 0L) continue;
                for (Future future : futures) {
                    result.add(future);
                }
                ArrayList<Future<T>> i$ = result;
                return i$;
            }
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ExecutionException value;
                start = System.nanoTime();
                try {
                    Future future = (Future)futures.get(i);
                    value = future.get(timeoutNanos, TimeUnit.NANOSECONDS);
                }
                catch (ExecutionException e) {
                    value = e;
                }
                catch (TimeoutException e) {
                    void var16_22;
                    done = false;
                    int n = i;
                    while (var16_22 < size) {
                        Future f = (Future)futures.get(i);
                        if (!f.isDone()) {
                            result.add(f);
                        } else {
                            Object v;
                            try {
                                v = f.get();
                            }
                            catch (ExecutionException ex) {
                                v = ex;
                            }
                            result.add(new CompletedFuture(this.getNodeEngine().getSerializationService(), v, this.getAsyncExecutor()));
                        }
                        ++var16_22;
                    }
                    break;
                }
                result.add(new CompletedFuture(this.getNodeEngine().getSerializationService(), value, this.getAsyncExecutor()));
                timeoutNanos -= System.nanoTime() - start;
            }
            {
            }
        }
        catch (Throwable t) {
            this.logger.severe(t);
        }
        finally {
            if (!done) {
                ExecutorServiceProxy.cancelAll(result);
            }
            return result;
        }
    }

    private static <T> void cancelAll(List<Future<T>> result) {
        for (Future<T> aResult : result) {
            aResult.cancel(true);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RuntimeException throwNotActiveException() {
        throw new RejectedExecutionException();
    }

    @Override
    public boolean isShutdown() {
        try {
            return ((DistributedExecutorService)this.getService()).isShutdown(this.name);
        }
        catch (HazelcastInstanceNotActiveException e) {
            return true;
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void shutdown() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        OperationService operationService = nodeEngine.getOperationService();
        LinkedList<Future> calls = new LinkedList<Future>();
        for (MemberImpl member : members) {
            if (member.localMember()) {
                ((DistributedExecutorService)this.getService()).shutdownExecutor(this.name);
                continue;
            }
            Future f = this.submitShutdownOperation(operationService, member);
            calls.add(f);
        }
        for (Future f : calls) {
            try {
                f.get(1L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest(exception);
            }
        }
    }

    private Future submitShutdownOperation(OperationService operationService, MemberImpl member) {
        ShutdownOperation op = new ShutdownOperation(this.name);
        return operationService.invokeOnTarget(this.getServiceName(), op, member.getAddress());
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats() {
        return ((DistributedExecutorService)this.getService()).getLocalExecutorStats(this.name);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public String getName() {
        return this.name;
    }

    private ExecutorService getAsyncExecutor() {
        return this.getNodeEngine().getExecutionService().getExecutor("hz:async");
    }

    private List<Member> selectMembers(MemberSelector memberSelector) {
        if (memberSelector == null) {
            throw new IllegalArgumentException("memberSelector must not be null");
        }
        ArrayList<Member> selected = new ArrayList<Member>();
        Collection<MemberImpl> members = this.getNodeEngine().getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (!memberSelector.select(member)) continue;
            selected.add(member);
        }
        return selected;
    }

    public String toString() {
        return "IExecutorService{name='" + this.name + '\'' + '}';
    }
}

