/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.jmx.ClientEngineMBean;
import com.hazelcast.jmx.ConnectionManagerMBean;
import com.hazelcast.jmx.EventServiceMBean;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagedExecutorServiceMBean;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.NodeMBean;
import com.hazelcast.jmx.OperationServiceMBean;
import com.hazelcast.jmx.PartitionServiceMBean;
import com.hazelcast.jmx.ProxyServiceMBean;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.OperationService;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

@ManagedDescription(value="HazelcastInstance")
public class InstanceMBean
extends HazelcastMBean<HazelcastInstanceImpl> {
    private static final int INITIAL_CAPACITY = 3;
    final Config config;
    final Cluster cluster;
    private final NodeMBean nodeMBean;
    private final ConnectionManagerMBean connectionManagerMBean;
    private final EventServiceMBean eventServiceMBean;
    private final OperationServiceMBean operationServiceMBean;
    private final ProxyServiceMBean proxyServiceMBean;
    private final ClientEngineMBean clientEngineMBean;
    private final ManagedExecutorServiceMBean systemExecutorMBean;
    private final ManagedExecutorServiceMBean operationExecutorMBean;
    private final ManagedExecutorServiceMBean asyncExecutorMBean;
    private final ManagedExecutorServiceMBean scheduledExecutorMBean;
    private final ManagedExecutorServiceMBean clientExecutorMBean;
    private final ManagedExecutorServiceMBean queryExecutorMBean;
    private final ManagedExecutorServiceMBean ioExecutorMBean;
    private final PartitionServiceMBean partitionServiceMBean;

    protected InstanceMBean(HazelcastInstanceImpl hazelcastInstance, ManagementService managementService) {
        super(hazelcastInstance, managementService);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("type", ManagementService.quote("HazelcastInstance"));
        properties.put("instance", ManagementService.quote(hazelcastInstance.getName()));
        properties.put("name", ManagementService.quote(hazelcastInstance.getName()));
        this.setObjectName(properties);
        this.config = hazelcastInstance.getConfig();
        this.cluster = hazelcastInstance.getCluster();
        Node node = hazelcastInstance.node;
        ExecutionService executionService = node.nodeEngine.getExecutionService();
        this.nodeMBean = new NodeMBean(hazelcastInstance, node, managementService);
        this.register(this.nodeMBean);
        this.connectionManagerMBean = new ConnectionManagerMBean(hazelcastInstance, node.connectionManager, this.service);
        this.register(this.connectionManagerMBean);
        this.eventServiceMBean = new EventServiceMBean(hazelcastInstance, node.nodeEngine.getEventService(), this.service);
        this.register(this.eventServiceMBean);
        OperationService operationService = node.nodeEngine.getOperationService();
        this.operationServiceMBean = new OperationServiceMBean(hazelcastInstance, operationService, this.service);
        this.register(this.operationServiceMBean);
        this.proxyServiceMBean = new ProxyServiceMBean(hazelcastInstance, node.nodeEngine.getProxyService(), this.service);
        this.register(this.proxyServiceMBean);
        this.partitionServiceMBean = new PartitionServiceMBean(hazelcastInstance, node.partitionService, this.service);
        this.register(this.partitionServiceMBean);
        this.clientEngineMBean = new ClientEngineMBean(hazelcastInstance, node.clientEngine, this.service);
        this.register(this.clientEngineMBean);
        this.systemExecutorMBean = new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:system"), this.service);
        this.register(this.systemExecutorMBean);
        this.operationExecutorMBean = new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:global-operation"), this.service);
        this.register(this.operationExecutorMBean);
        this.asyncExecutorMBean = new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:async"), this.service);
        this.register(this.asyncExecutorMBean);
        this.scheduledExecutorMBean = new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:scheduled"), this.service);
        this.register(this.scheduledExecutorMBean);
        this.clientExecutorMBean = new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:client"), this.service);
        this.register(this.clientExecutorMBean);
        this.queryExecutorMBean = new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:query"), this.service);
        this.register(this.queryExecutorMBean);
        this.ioExecutorMBean = new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:io"), this.service);
        this.register(this.ioExecutorMBean);
    }

    public PartitionServiceMBean getPartitionServiceMBean() {
        return this.partitionServiceMBean;
    }

    public ManagedExecutorServiceMBean getSystemExecutorMBean() {
        return this.systemExecutorMBean;
    }

    public ManagedExecutorServiceMBean getOperationExecutorMBean() {
        return this.operationExecutorMBean;
    }

    public ManagedExecutorServiceMBean getAsyncExecutorMBean() {
        return this.asyncExecutorMBean;
    }

    public ManagedExecutorServiceMBean getScheduledExecutorMBean() {
        return this.scheduledExecutorMBean;
    }

    public ManagedExecutorServiceMBean getClientExecutorMBean() {
        return this.clientExecutorMBean;
    }

    public ManagedExecutorServiceMBean getQueryExecutorMBean() {
        return this.queryExecutorMBean;
    }

    public ManagedExecutorServiceMBean getIoExecutorMBean() {
        return this.ioExecutorMBean;
    }

    public OperationServiceMBean getOperationServiceMBean() {
        return this.operationServiceMBean;
    }

    public ProxyServiceMBean getProxyServiceMBean() {
        return this.proxyServiceMBean;
    }

    public ClientEngineMBean getClientEngineMBean() {
        return this.clientEngineMBean;
    }

    public ConnectionManagerMBean getConnectionManagerMBean() {
        return this.connectionManagerMBean;
    }

    public EventServiceMBean getEventServiceMBean() {
        return this.eventServiceMBean;
    }

    public NodeMBean getNodeMBean() {
        return this.nodeMBean;
    }

    public HazelcastInstance getHazelcastInstance() {
        return (HazelcastInstance)this.managedObject;
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the Instance")
    public String getName() {
        return ((HazelcastInstanceImpl)this.managedObject).getName();
    }

    @ManagedAnnotation(value="version")
    @ManagedDescription(value="The Hazelcast version")
    public String getVersion() {
        return ((HazelcastInstanceImpl)this.managedObject).node.getBuildInfo().getVersion();
    }

    @ManagedAnnotation(value="build")
    @ManagedDescription(value="The Hazelcast build")
    public String getBuild() {
        return ((HazelcastInstanceImpl)this.managedObject).node.getBuildInfo().getBuild();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="String representation of config")
    public String getConfig() {
        return this.config.toString();
    }

    @ManagedAnnotation(value="configSource")
    @ManagedDescription(value="The source of config")
    public String getConfigSource() {
        File configurationFile = this.config.getConfigurationFile();
        if (configurationFile != null) {
            return configurationFile.getAbsolutePath();
        }
        URL configurationUrl = this.config.getConfigurationUrl();
        if (configurationUrl != null) {
            return configurationUrl.toString();
        }
        return null;
    }

    @ManagedAnnotation(value="groupName")
    @ManagedDescription(value="Group Name")
    public String getGroupName() {
        return this.config.getGroupConfig().getName();
    }

    @ManagedAnnotation(value="port")
    @ManagedDescription(value="Network Port")
    public int getPort() {
        return this.config.getNetworkConfig().getPort();
    }

    @ManagedAnnotation(value="clusterTime")
    @ManagedDescription(value="Cluster-wide Time")
    public long getClusterTime() {
        return this.cluster.getClusterTime();
    }

    @ManagedAnnotation(value="memberCount")
    @ManagedDescription(value="size of the cluster")
    public int getMemberCount() {
        return this.cluster.getMembers().size();
    }

    @ManagedAnnotation(value="Members")
    @ManagedDescription(value="List of Members")
    public List<String> getMembers() {
        Set<Member> members = this.cluster.getMembers();
        ArrayList<String> list = new ArrayList<String>(members.size());
        for (Member member : members) {
            list.add(member.getSocketAddress().toString());
        }
        return list;
    }

    @ManagedAnnotation(value="running")
    @ManagedDescription(value="Running state")
    public boolean isRunning() {
        return ((HazelcastInstanceImpl)this.managedObject).getLifecycleService().isRunning();
    }

    @ManagedAnnotation(value="shutdown", operation=true)
    @ManagedDescription(value="Shutdown the Node")
    public void shutdown() {
        ((HazelcastInstanceImpl)this.managedObject).getLifecycleService().shutdown();
    }
}

