/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.management.JsonSerializable;
import com.hazelcast.util.JsonUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManagementCenterIdentifier
implements JsonSerializable {
    private int version;
    private String clusterName;
    private String address;
    public transient String versionString;

    public static int getVersionAsInt(String versionString) throws IllegalArgumentException {
        int version = 0;
        Pattern pattern = Pattern.compile("^(\\d)\\.(\\d)(?:\\.(\\d))?+.*");
        Matcher matcher = pattern.matcher(versionString);
        if (matcher.matches()) {
            for (int i = 1; i < matcher.groupCount() + 1; ++i) {
                version *= 10;
                version += Integer.parseInt(matcher.group(i) == null ? "0" : matcher.group(i));
            }
            return version;
        }
        throw new IllegalArgumentException(String.format("version string '%s' is not valid", versionString));
    }

    public static String convertVersionToString(int version) {
        StringBuilder builder = new StringBuilder();
        String v = Integer.toString(version);
        builder.append(v.charAt(0));
        builder.append('.');
        builder.append(v.charAt(1));
        builder.append('.');
        builder.append(v.charAt(2));
        return builder.toString();
    }

    public ManagementCenterIdentifier() {
    }

    public ManagementCenterIdentifier(String version, String clusterName, String address) {
        this.version = ManagementCenterIdentifier.getVersionAsInt(version);
        this.clusterName = clusterName;
        this.address = address;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("version", this.version);
        root.add("clusterName", this.clusterName);
        root.add("address", this.address);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.version = JsonUtil.getInt(json, "version");
        this.clusterName = JsonUtil.getString(json, "clusterName");
        this.address = JsonUtil.getString(json, "address");
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionString() {
        if (this.versionString == null) {
            this.versionString = ManagementCenterIdentifier.convertVersionToString(this.version);
        }
        return this.versionString;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getAddress() {
        return this.address;
    }
}

