/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryView;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.SizeEstimators;
import com.hazelcast.map.eviction.EvictionHelper;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.operation.PutAllOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.map.writebehind.DelayedEntry;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueues;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.ExceptionUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultRecordStore
implements RecordStore {
    private static final long DEFAULT_TTL = -1L;
    private static final byte POST_READ_CHECK_POINT = 63;
    private final String name;
    private final int partitionId;
    private final ConcurrentMap<Data, Record> records = new ConcurrentHashMap<Data, Record>(1000);
    private final MapContainer mapContainer;
    private final MapService mapService;
    private final LockStore lockStore;
    private final RecordFactory recordFactory;
    private final ILogger logger;
    private final SizeEstimator sizeEstimator;
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private final WriteBehindQueue<DelayedEntry> writeBehindQueue;
    private long lastEvictionTime;
    private byte readCountBeforeCleanUp;
    private final Set<Data> writeBehindWaitingDeletions;
    private long lruAccessSequenceNumber;

    public DefaultRecordStore(String name, MapService mapService, int partitionId) {
        this.name = name;
        this.partitionId = partitionId;
        this.mapService = mapService;
        this.mapContainer = mapService.getMapContainer(name);
        this.logger = mapService.getNodeEngine().getLogger(this.getName());
        this.recordFactory = this.mapContainer.getRecordFactory();
        this.writeBehindQueue = WriteBehindQueues.createDefaultWriteBehindQueue(this.mapContainer.isWriteBehindMapStoreEnabled());
        this.writeBehindWaitingDeletions = this.mapContainer.isWriteBehindMapStoreEnabled() ? Collections.newSetFromMap(new ConcurrentHashMap()) : Collections.EMPTY_SET;
        NodeEngine nodeEngine = mapService.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionId, new DefaultObjectNamespace("hz:impl:mapService", name));
        this.sizeEstimator = SizeEstimators.createMapSizeEstimator();
        this.loadFromMapStore(nodeEngine);
    }

    @Override
    public boolean isLoaded() {
        return this.loaded.get();
    }

    @Override
    public void setLoaded(boolean isLoaded) {
        this.loaded.set(isLoaded);
    }

    @Override
    public void checkIfLoaded() {
        if (this.mapContainer.getStore() != null && !this.loaded.get()) {
            throw ExceptionUtil.rethrow(new RetryableHazelcastException("Map is not ready!!!"));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
        this.checkIfLoaded();
        Collection<Data> processedKeys = this.mapContainer.getWriteBehindManager().flush(this.writeBehindQueue);
        for (Data pkey : processedKeys) {
            Record record = (Record)this.records.get(pkey);
            if (record == null) continue;
            record.onStore();
        }
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public Record getRecord(Data key) {
        return (Record)this.records.get(key);
    }

    @Override
    public void putForReplication(Data key, Record record) {
        Record existingRecord = this.records.put(key, record);
        this.updateSizeEstimator(-this.calculateRecordSize(existingRecord));
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.removeFromWriteBehindWaitingDeletions(key);
    }

    @Override
    public Record putBackup(Data key, Object value) {
        return this.putBackup(key, value, -1L);
    }

    @Override
    public Record putBackup(Data key, Object value, long ttl) {
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            record = this.mapService.createRecord(this.name, key, value, ttl);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        this.removeFromWriteBehindWaitingDeletions(key);
        this.addToDelayedStore(key, record.getValue());
        return record;
    }

    @Override
    public void deleteRecord(Data key) {
        Record record = (Record)this.records.remove(key);
        if (record != null) {
            record.invalidate();
        }
    }

    @Override
    public Map<Data, Record> getReadonlyRecordMap() {
        return Collections.unmodifiableMap(this.records);
    }

    @Override
    public void clearPartition() {
        IndexService indexService;
        NodeEngine nodeEngine = this.mapService.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", this.name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
        if ((indexService = this.mapContainer.getIndexService()).hasIndex()) {
            for (Data key : this.records.keySet()) {
                indexService.removeEntryIndex(key);
            }
        }
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
    }

    private void clearRecordsMap(Map<Data, Record> excludeRecords) {
        InMemoryFormat inMemoryFormat = this.recordFactory.getStorageFormat();
        switch (inMemoryFormat) {
            case BINARY: 
            case OBJECT: {
                this.records.clear();
                if (excludeRecords != null && !excludeRecords.isEmpty()) {
                    this.records.putAll(excludeRecords);
                }
                return;
            }
            case OFFHEAP: {
                Iterator iter = this.records.values().iterator();
                while (iter.hasNext()) {
                    Record record = (Record)iter.next();
                    if (excludeRecords != null && excludeRecords.containsKey(record.getKey())) continue;
                    record.invalidate();
                    iter.remove();
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown storage format: " + (Object)((Object)inMemoryFormat));
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkIfLoaded();
        return this.records.isEmpty();
    }

    @Override
    public WriteBehindQueue<DelayedEntry> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    @Override
    public List findUnlockedExpiredRecords() {
        this.checkIfLoaded();
        long nowInNanos = DefaultRecordStore.nowInNanos();
        List expiredKeyValueSequence = Collections.emptyList();
        boolean createLazy = true;
        for (Map.Entry entry : this.records.entrySet()) {
            Record record;
            Data key = (Data)entry.getKey();
            if (this.isLocked(key) || this.isReachable(record = (Record)entry.getValue(), nowInNanos)) continue;
            Object value = record.getValue();
            this.evict(key);
            if (createLazy) {
                expiredKeyValueSequence = new ArrayList();
                createLazy = false;
            }
            expiredKeyValueSequence.add(key);
            expiredKeyValueSequence.add(value);
        }
        return expiredKeyValueSequence;
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkIfLoaded();
        for (Record record : this.records.values()) {
            if (this.nullIfExpired(record) == null || !this.mapService.compare(this.name, value, record.getValue())) continue;
            return true;
        }
        this.postReadCleanUp();
        return false;
    }

    @Override
    public boolean lock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.lock(key, caller, threadId, ttl);
    }

    @Override
    public boolean txnLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, long threadId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public long getHeapCost() {
        return this.getSizeEstimator().getSize();
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, long threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    @Override
    public Set<Map.Entry<Data, Data>> entrySetData() {
        this.checkIfLoaded();
        HashMap<Data, Data> temp = new HashMap<Data, Data>(this.records.size());
        for (Data key : this.records.keySet()) {
            temp.put(key, this.mapService.toData(((Record)this.records.get(key)).getValue()));
        }
        return temp.entrySet();
    }

    @Override
    public Map.Entry<Data, Object> getMapEntry(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            record = this.getRecordInternal(dataKey, true);
        } else {
            this.accessRecord(record);
        }
        Object data = record != null ? (Object)record.getValue() : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, data);
    }

    @Override
    public Map.Entry<Data, Object> getMapEntryForBackup(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            record = this.getRecordInternal(dataKey, false);
        } else {
            this.accessRecord(record);
        }
        Object data = record != null ? (Object)record.getValue() : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, data);
    }

    private Record getRecordInternal(Data dataKey, boolean enableIndex) {
        Object value;
        Record record = null;
        if (this.mapContainer.getStore() != null && (value = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
            record = this.mapService.createRecord(this.name, dataKey, value, -1L);
            this.records.put(dataKey, record);
            if (enableIndex) {
                this.saveIndex(record);
            }
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        return record;
    }

    @Override
    public Set<Data> keySet() {
        this.checkIfLoaded();
        HashSet<Data> keySet = new HashSet<Data>(this.records.size());
        for (Data data : this.records.keySet()) {
            keySet.add(data);
        }
        return keySet;
    }

    @Override
    public Collection<Data> valuesData() {
        this.checkIfLoaded();
        ArrayList<Data> values = new ArrayList<Data>(this.records.size());
        for (Record record : this.records.values()) {
            values.add(this.mapService.toData(record.getValue()));
        }
        return values;
    }

    @Override
    public void clear() {
        this.checkIfLoaded();
        this.resetSizeEstimator();
        Set<Data> lockedKeys = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        Set<Data> keysToDelete = this.records.keySet();
        keysToDelete.removeAll(lockedRecords.keySet());
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store != null) {
            ArrayList<Object> keysObject = new ArrayList<Object>(keysToDelete.size());
            for (Data key : keysToDelete) {
                keysObject.add(this.mapService.toObject(key));
            }
            store.deleteAll(keysObject);
        }
        this.removeIndex(keysToDelete);
        this.clearRecordsMap(lockedRecords);
        this.resetAccessSequenceNumber();
        this.writeBehindQueue.clear();
    }

    @Override
    public void reset() {
        this.checkIfLoaded();
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        this.writeBehindQueue.clear();
        this.writeBehindWaitingDeletions.clear();
    }

    private void resetAccessSequenceNumber() {
        this.lruAccessSequenceNumber = 0L;
    }

    @Override
    public Object evict(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record != null) {
            this.mapService.interceptRemove(this.name, record.getValue());
            oldValue = record.getValue();
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.deleteRecord(dataKey);
            this.removeIndex(dataKey);
        }
        return oldValue;
    }

    @Override
    public void removeBackup(Data key) {
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            return;
        }
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.deleteRecord(key);
        this.addToWriteBehindWaitingDeletions(key);
        this.addToDelayedStore(key, null);
    }

    @Override
    public boolean remove(Data dataKey, Object testValue) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        boolean removed = false;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey));
            }
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.mapService.compare(this.name, testValue, oldValue)) {
            this.mapService.interceptRemove(this.name, oldValue);
            this.removeIndex(dataKey);
            this.mapStoreDelete(record, dataKey);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.deleteRecord(dataKey);
            removed = true;
        }
        return removed;
    }

    @Override
    public Object remove(Data dataKey) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
                this.removeIndex(dataKey);
                this.mapStoreDelete(null, dataKey);
            }
        } else {
            oldValue = record.getValue();
            if ((oldValue = this.mapService.interceptRemove(this.name, oldValue)) != null) {
                this.removeIndex(dataKey);
                this.mapStoreDelete(record, dataKey);
            }
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.deleteRecord(dataKey);
        }
        return oldValue;
    }

    @Override
    public Object get(Data key) {
        this.checkIfLoaded();
        if (this.hasWaitingWriteBehindDeleteOperation(key)) {
            return null;
        }
        Record record = (Record)this.records.get(key);
        record = this.nullIfExpired(record);
        Object value = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (value = this.mapContainer.getStore().load(this.mapService.toObject(key))) != null) {
                record = this.mapService.createRecord(this.name, key, value, -1L);
                this.records.put(key, record);
                this.saveIndex(record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            }
        } else {
            this.accessRecord(record);
            value = record.getValue();
        }
        value = this.mapService.interceptGet(this.name, value);
        this.postReadCleanUp();
        return value;
    }

    @Override
    public MapEntrySet getAll(Set<Data> keySet) {
        this.checkIfLoaded();
        MapEntrySet mapEntrySet = new MapEntrySet();
        Map<Object, Data> keyMapForLoader = Collections.emptyMap();
        if (this.mapContainer.getStore() != null) {
            keyMapForLoader = new HashMap();
        }
        for (Data dataKey : keySet) {
            Record record = (Record)this.records.get(dataKey);
            if (this.hasWaitingWriteBehindDeleteOperation(dataKey)) continue;
            if (record == null) {
                if (this.mapContainer.getStore() == null) continue;
                keyMapForLoader.put(this.mapService.toObject(dataKey), dataKey);
                continue;
            }
            this.accessRecord(record);
            Object value = record.getValue();
            if ((value = this.mapService.interceptGet(this.name, value)) == null) continue;
            mapEntrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, this.mapService.toData(value)));
        }
        if (this.mapContainer.getStore() == null || keyMapForLoader.size() == 0) {
            return mapEntrySet;
        }
        Map loadedKeys = this.mapContainer.getStore().loadAll((Collection)keyMapForLoader.keySet());
        for (Map.Entry entry : loadedKeys.entrySet()) {
            Object objectKey = entry.getKey();
            Object value = entry.getValue();
            Data dataKey = (Data)keyMapForLoader.get(objectKey);
            if (this.hasWaitingWriteBehindDeleteOperation(dataKey)) continue;
            if (value != null) {
                Record record = this.mapService.createRecord(this.name, dataKey, value, -1L);
                this.records.put(dataKey, record);
                this.saveIndex(record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            }
            if ((value = this.mapService.interceptGet(this.name, value)) == null) continue;
            mapEntrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, this.mapService.toData(value)));
        }
        return mapEntrySet;
    }

    @Override
    public boolean containsKey(Data key) {
        boolean contains;
        Object value;
        this.checkIfLoaded();
        Record record = (Record)this.records.get(key);
        if (this.hasWaitingWriteBehindDeleteOperation(key)) {
            return false;
        }
        if ((record = this.nullIfExpired(record)) == null && this.mapContainer.getStore() != null && (value = this.mapContainer.getStore().load(this.mapService.toObject(key))) != null) {
            record = this.mapService.createRecord(this.name, key, value, -1L);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        boolean bl = contains = record != null;
        if (contains) {
            this.accessRecord(record);
        }
        this.postReadCleanUp();
        return contains;
    }

    @Override
    public void put(Map.Entry<Data, Object> entry) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Data key = entry.getKey();
        Object value = entry.getValue();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null);
            record = this.mapService.createRecord(this.name, key, value, -1L);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        } else {
            Object oldValue = record.getValue();
            value = this.mapService.interceptPut(this.name, oldValue, value);
            value = this.mapStoreWrite(key, value, record);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        }
        this.removeFromWriteBehindWaitingDeletions(key);
    }

    @Override
    public Object put(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.mapContainer.getStore().load(this.mapService.toObject(key));
            }
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null);
            record = this.mapService.createRecord(this.name, key, value, ttl);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        } else {
            oldValue = record.getValue();
            value = this.mapService.interceptPut(this.name, oldValue, value);
            value = this.mapStoreWrite(key, value, record);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
            this.saveIndex(record);
        }
        this.removeFromWriteBehindWaitingDeletions(key);
        return oldValue;
    }

    @Override
    public boolean set(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        boolean newRecord = false;
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null);
            record = this.mapService.createRecord(this.name, key, value, ttl);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            newRecord = true;
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            value = this.mapStoreWrite(key, value, record);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
        return newRecord;
    }

    @Override
    public boolean merge(Data key, EntryView mergingEntry, MapMergePolicy mergePolicy) {
        Object newValue;
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            Object notExistingKey = this.mapService.toObject(key);
            EntryView nullEntryView = EntryViews.createNullEntryView(notExistingKey);
            newValue = mergePolicy.merge(this.name, mergingEntry, nullEntryView);
            if (newValue == null) {
                return false;
            }
            newValue = this.mapStoreWrite(key, newValue, null);
            record = this.mapService.createRecord(this.name, key, newValue, -1L);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            Object oldValue = record.getValue();
            EntryView<Object, Object> existingEntry = EntryViews.createSimpleEntryView(this.mapService.toObject(record.getKey()), this.mapService.toObject(record.getValue()), record);
            newValue = mergePolicy.merge(this.name, mergingEntry, existingEntry);
            if (newValue == null) {
                this.removeIndex(key);
                this.mapStoreDelete(record, key);
                this.updateSizeEstimator(-this.calculateRecordSize(record));
                this.deleteRecord(key);
                return true;
            }
            if (this.mapService.compare(this.name, newValue, oldValue)) {
                return true;
            }
            newValue = this.mapStoreWrite(key, newValue, record);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.recordFactory.setValue(record, newValue);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        this.saveIndex(record);
        return newValue != null;
    }

    @Override
    public Object replace(Data dataKey, Object value) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(dataKey);
        if (record == null || record.getValue() == null) {
            return null;
        }
        Object oldValue = record.getValue();
        value = this.mapService.interceptPut(this.name, oldValue, value);
        value = this.mapStoreWrite(dataKey, value, record);
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.setRecordValue(record, value);
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean replace(Data dataKey, Object testValue, Object newValue) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            return false;
        }
        if (!this.mapService.compare(this.name, record.getValue(), testValue)) {
            return false;
        }
        newValue = this.mapService.interceptPut(this.name, record.getValue(), newValue);
        newValue = this.mapStoreWrite(dataKey, newValue, record);
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.setRecordValue(record, newValue);
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.saveIndex(record);
        return true;
    }

    @Override
    public void putTransient(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, key, value, ttl);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
    }

    @Override
    public void putFromLoad(Data key, Object value, long ttl) {
        Record record = (Record)this.records.get(key);
        this.earlyWriteCleanup();
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, key, value, ttl);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
    }

    @Override
    public boolean tryPut(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null);
            record = this.mapService.createRecord(this.name, key, value, ttl);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            value = this.mapStoreWrite(key, value, record);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
        return true;
    }

    @Override
    public Object putIfAbsent(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        this.earlyWriteCleanup();
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.mapContainer.getStore().load(this.mapService.toObject(key))) != null) {
                record = this.mapService.createRecord(this.name, key, oldValue, -1L);
                this.records.put(key, record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            }
        } else {
            this.accessRecord(record);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, record);
            record = this.mapService.createRecord(this.name, key, value, ttl);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
        return oldValue;
    }

    private void loadFromMapStore(NodeEngine nodeEngine) {
        AtomicBoolean loadOccurred = this.loaded;
        if (!this.mapContainer.isMapStoreEnabled() || loadOccurred.get()) {
            return;
        }
        Address partitionOwner = nodeEngine.getPartitionService().getPartitionOwner(this.partitionId);
        boolean isOwner = nodeEngine.getThisAddress().equals(partitionOwner);
        if (!isOwner) {
            loadOccurred.set(true);
            return;
        }
        Map<Data, Object> loadedKeys = this.mapContainer.getInitialKeys();
        if (loadedKeys == null || loadedKeys.isEmpty()) {
            loadOccurred.set(true);
            return;
        }
        this.doChunkedLoad(loadedKeys, nodeEngine);
    }

    private void doChunkedLoad(Map<Data, Object> loadedKeys, NodeEngine nodeEngine) {
        int mapLoadChunkSize = nodeEngine.getGroupProperties().MAP_LOAD_CHUNK_SIZE.getInteger();
        LinkedList chunks = new LinkedList();
        HashMap<Data, Object> partitionKeys = new HashMap<Data, Object>();
        Iterator<Map.Entry<Data, Object>> iterator = loadedKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Data, Object> entry = iterator.next();
            Data data = entry.getKey();
            if (this.partitionId != nodeEngine.getPartitionService().getPartitionId(data)) continue;
            partitionKeys.put(data, entry.getValue());
            if (partitionKeys.size() >= mapLoadChunkSize) {
                chunks.add(partitionKeys);
                partitionKeys = new HashMap();
            }
            iterator.remove();
        }
        if (!partitionKeys.isEmpty()) {
            chunks.add(partitionKeys);
        }
        if (chunks.isEmpty()) {
            this.loaded.set(true);
            return;
        }
        try {
            Map chunkedKeys;
            AtomicInteger checkIfMapLoaded = new AtomicInteger(chunks.size());
            ExecutionService executionService = nodeEngine.getExecutionService();
            while ((chunkedKeys = (Map)chunks.poll()) != null) {
                executionService.submit("hz:map-load", new MapLoadAllTask(chunkedKeys, checkIfMapLoaded));
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void earlyWriteCleanup() {
        if (!this.mapContainer.isEvictionEnabled()) {
            return;
        }
        this.cleanUp();
    }

    private void postReadCleanUp() {
        if (!this.mapContainer.isEvictionEnabled()) {
            return;
        }
        this.readCountBeforeCleanUp = (byte)(this.readCountBeforeCleanUp + 1);
        if ((this.readCountBeforeCleanUp & 0x3F) == 0) {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        long now = System.currentTimeMillis();
        int evictAfterMs = 1000;
        if (now - this.lastEvictionTime <= 1000L) {
            return;
        }
        boolean evictable = EvictionHelper.checkEvictable(this.mapContainer);
        if (!evictable) {
            return;
        }
        EvictionHelper.removeEvictableRecords(this, this.mapContainer.getMapConfig(), this.mapService);
        this.lastEvictionTime = now;
        this.readCountBeforeCleanUp = 0;
    }

    private Record nullIfExpired(Record record) {
        return this.evictIfNotReachable(record);
    }

    private void addToWriteBehindWaitingDeletions(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        this.writeBehindWaitingDeletions.add(key);
    }

    @Override
    public void removeFromWriteBehindWaitingDeletions(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        this.writeBehindWaitingDeletions.remove(key);
    }

    private boolean hasWaitingWriteBehindDeleteOperation(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return false;
        }
        return this.writeBehindWaitingDeletions.contains(key);
    }

    private Record evictIfNotReachable(Record record) {
        if (record == null) {
            return null;
        }
        if (this.isLocked(record.getKey())) {
            return record;
        }
        if (this.isReachable(record)) {
            return record;
        }
        Data key = record.getKey();
        Object value = record.getValue();
        this.evict(key);
        this.doPostEvictionOperations(key, value);
        return null;
    }

    private boolean isReachable(Record record) {
        return this.isReachable(record, DefaultRecordStore.nowInNanos());
    }

    private boolean isReachable(Record record, long timeInNanos) {
        Record result = this.mapContainer.getReachabilityHandlerChain().isReachable(record, -1L, timeInNanos);
        return result != null;
    }

    private void doPostEvictionOperations(Data key, Object value) {
        this.mapService.interceptAfterRemove(this.name, value);
        if (this.mapService.isNearCacheAndInvalidationEnabled(this.name)) {
            this.mapService.invalidateAllNearCaches(this.name, key);
        }
        EvictionHelper.fireEvent(key, value, this.name, this.mapService);
    }

    private void accessRecord(Record record) {
        this.increaseRecordEvictionCriteriaNumber(record, this.mapContainer.getMapConfig().getEvictionPolicy());
        record.onAccess();
    }

    private void increaseRecordEvictionCriteriaNumber(Record record, MapConfig.EvictionPolicy evictionPolicy) {
        switch (evictionPolicy) {
            case LRU: {
                ++this.lruAccessSequenceNumber;
                record.setEvictionCriteriaNumber(this.lruAccessSequenceNumber);
                break;
            }
            case LFU: {
                record.setEvictionCriteriaNumber(record.getEvictionCriteriaNumber() + 1L);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate eviction policy [" + (Object)((Object)evictionPolicy) + ']');
            }
        }
    }

    private void saveIndex(Record record) {
        Data dataKey = record.getKey();
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            SerializationService ss = this.mapService.getSerializationService();
            QueryEntry queryableEntry = new QueryEntry(ss, dataKey, dataKey, record.getValue());
            indexService.saveEntryIndex(queryableEntry);
        }
    }

    private Object mapStoreWrite(Data dataKey, Object recordValue, Record record) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store == null) {
            return recordValue;
        }
        if (this.mapContainer.getWriteDelayMillis() < 1L) {
            Object objectValue = this.mapService.toObject(recordValue);
            store.store(this.mapService.toObject(dataKey), objectValue);
            if (record != null) {
                record.onStore();
            }
            return store.isPostProcessingMapStore() ? objectValue : recordValue;
        }
        this.addToDelayedStore(dataKey, recordValue);
        return recordValue;
    }

    private void mapStoreDelete(Record record, Data key) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store == null) {
            return;
        }
        long writeDelayMillis = this.mapContainer.getWriteDelayMillis();
        if (writeDelayMillis < 1L) {
            store.delete(this.mapService.toObject(key));
            if (record != null) {
                record.onStore();
            }
            return;
        }
        this.addToDelayedStore(key, null);
    }

    private void addToDelayedStore(Data dataKey, Object recordValue) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        long writeDelayMillis = this.mapContainer.getWriteDelayMillis();
        DelayedEntry<Data, Object> delayedEntry = this.mapService.constructDelayedEntry(dataKey, recordValue, this.partitionId, writeDelayMillis);
        if (recordValue == null) {
            this.addToWriteBehindWaitingDeletions(dataKey);
        }
        this.writeBehindQueue.offer(delayedEntry);
    }

    @Override
    public SizeEstimator getSizeEstimator() {
        return this.sizeEstimator;
    }

    private void updateTtl(Record record, long ttlInMillis) {
        if (ttlInMillis < 0L) {
            return;
        }
        long ttlInNanos = TimeUnit.MILLISECONDS.toNanos(ttlInMillis);
        record.setTtl(ttlInNanos);
        if (record.getStatistics() != null) {
            record.getStatistics().setExpirationTime(System.nanoTime() + ttlInNanos);
        }
    }

    private static long nowInNanos() {
        return System.nanoTime();
    }

    private void updateSizeEstimator(long recordSize) {
        this.sizeEstimator.add(recordSize);
    }

    private long calculateRecordSize(Record record) {
        return this.sizeEstimator.getCost(record);
    }

    private void resetSizeEstimator() {
        this.sizeEstimator.reset();
    }

    private void setRecordValue(Record record, Object value) {
        this.accessRecord(record);
        record.onUpdate();
        this.recordFactory.setValue(record, value);
    }

    private void removeIndex(Data key) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            indexService.removeEntryIndex(key);
        }
    }

    private void removeIndex(Set<Data> keys) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            for (Data key : keys) {
                indexService.removeEntryIndex(key);
            }
        }
    }

    private final class MapLoadAllTask
    implements Runnable {
        private Map<Data, Object> keys;
        private AtomicInteger checkIfMapLoaded;

        private MapLoadAllTask(Map<Data, Object> keys, AtomicInteger checkIfMapLoaded) {
            this.keys = keys;
            this.checkIfMapLoaded = checkIfMapLoaded;
        }

        @Override
        public void run() {
            NodeEngine nodeEngine = DefaultRecordStore.this.mapService.getNodeEngine();
            try {
                Map values = DefaultRecordStore.this.mapContainer.getStore().loadAll(this.keys.values());
                if (values == null || values.isEmpty()) {
                    if (this.checkIfMapLoaded.decrementAndGet() == 0) {
                        DefaultRecordStore.this.loaded.set(true);
                    }
                    return;
                }
                MapEntrySet entrySet = new MapEntrySet();
                for (Data dataKey : this.keys.keySet()) {
                    Object key = this.keys.get(dataKey);
                    Object value = values.get(key);
                    if (value == null) continue;
                    Data dataValue = DefaultRecordStore.this.mapService.toData(value);
                    entrySet.add(dataKey, dataValue);
                }
                PutAllOperation operation = new PutAllOperation(DefaultRecordStore.this.name, entrySet, true);
                operation.setNodeEngine(nodeEngine);
                operation.setResponseHandler(new ResponseHandler(){

                    @Override
                    public void sendResponse(Object obj) {
                        if (MapLoadAllTask.this.checkIfMapLoaded.decrementAndGet() == 0) {
                            DefaultRecordStore.this.loaded.set(true);
                        }
                    }

                    @Override
                    public boolean isLocal() {
                        return true;
                    }
                });
                operation.setPartitionId(DefaultRecordStore.this.partitionId);
                OperationAccessor.setCallerAddress(operation, nodeEngine.getThisAddress());
                operation.setCallerUuid(nodeEngine.getLocalMember().getUuid());
                operation.setServiceName("hz:impl:mapService");
                nodeEngine.getOperationService().executeOperation(operation);
            }
            catch (Exception e) {
                DefaultRecordStore.this.logger.warning("Exception while load all task:" + e.toString());
            }
        }
    }
}

