/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStoreFactory;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.SizeEstimators;
import com.hazelcast.map.eviction.ReachabilityHandlerChain;
import com.hazelcast.map.eviction.ReachabilityHandlers;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.operation.ClearExpiredOperation;
import com.hazelcast.map.record.DataRecordFactory;
import com.hazelcast.map.record.ObjectRecordFactory;
import com.hazelcast.map.record.OffHeapRecordFactory;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.map.writebehind.DelayedEntry;
import com.hazelcast.map.writebehind.WriteBehindManager;
import com.hazelcast.map.writebehind.WriteBehindManagers;
import com.hazelcast.map.writebehind.store.StoreEvent;
import com.hazelcast.map.writebehind.store.StoreListener;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.WanReplicationService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class MapContainer {
    private volatile MapConfig mapConfig;
    private final String name;
    private final RecordFactory recordFactory;
    private final MapService mapService;
    private MapStoreWrapper storeWrapper;
    private final List<MapInterceptor> interceptors;
    private final Map<String, MapInterceptor> interceptorMap;
    private final IndexService indexService = new IndexService();
    private final boolean nearCacheEnabled;
    private final ReachabilityHandlerChain reachabilityHandlerChain;
    private final SizeEstimator nearCacheSizeEstimator;
    private final Map<Data, Object> initialKeys = new ConcurrentHashMap<Data, Object>();
    private final PartitioningStrategy partitioningStrategy;
    private WriteBehindManager writeBehindQueueManager;
    private WanReplicationPublisher wanReplicationPublisher;
    private MapMergePolicy wanMergePolicy;
    private final boolean evictionEnabled;

    public MapContainer(String name, MapConfig mapConfig, MapService mapService) {
        this.name = name;
        this.mapConfig = mapConfig;
        this.mapService = mapService;
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.reachabilityHandlerChain = ReachabilityHandlers.newHandlerChain(this);
        NodeEngine nodeEngine = mapService.getNodeEngine();
        this.recordFactory = this.createRecordFactory(nodeEngine);
        this.initMapStoreOperations(nodeEngine);
        this.initWanReplication(nodeEngine);
        this.interceptors = new CopyOnWriteArrayList<MapInterceptor>();
        this.interceptorMap = new ConcurrentHashMap<String, MapInterceptor>();
        this.nearCacheEnabled = mapConfig.getNearCacheConfig() != null;
        this.nearCacheSizeEstimator = SizeEstimators.createNearCacheSizeEstimator();
        this.evictionEnabled = !MapConfig.EvictionPolicy.NONE.equals((Object)mapConfig.getEvictionPolicy());
        mapService.getNodeEngine().getExecutionService().scheduleAtFixedRate(new ClearExpiredRecordsTask(), 5L, 5L, TimeUnit.SECONDS);
    }

    private Operation createExpirationOperation(int partitionId) {
        MapService mapService = this.mapService;
        ClearExpiredOperation clearExpiredOperation = new ClearExpiredOperation(this.name);
        clearExpiredOperation.setNodeEngine(mapService.getNodeEngine()).setCallerUuid(mapService.getNodeEngine().getLocalMember().getUuid()).setPartitionId(partitionId).setValidateTarget(false).setService(mapService);
        return clearExpiredOperation;
    }

    public boolean isEvictionEnabled() {
        return this.evictionEnabled;
    }

    private void initMapStoreOperations(NodeEngine nodeEngine) {
        if (!this.isMapStoreEnabled()) {
            this.writeBehindQueueManager = WriteBehindManagers.emptyWriteBehindManager();
            return;
        }
        this.storeWrapper = this.createMapStoreWrapper(this.mapConfig.getMapStoreConfig(), nodeEngine);
        if (this.storeWrapper != null) {
            this.initMapStore(this.storeWrapper.getImpl(), this.mapConfig.getMapStoreConfig(), nodeEngine);
        }
        if (!this.isWriteBehindMapStoreEnabled()) {
            this.writeBehindQueueManager = WriteBehindManagers.emptyWriteBehindManager();
            return;
        }
        this.initWriteBehindMapStore();
    }

    private void initWriteBehindMapStore() {
        if (!this.isWriteBehindMapStoreEnabled()) {
            return;
        }
        this.writeBehindQueueManager = WriteBehindManagers.createWriteBehindManager(this.name, this.mapService, this.storeWrapper);
        this.writeBehindQueueManager.addStoreListener(new StoreListener<DelayedEntry>(){

            @Override
            public void beforeStore(StoreEvent<DelayedEntry> storeEvent) {
            }

            @Override
            public void afterStore(StoreEvent<DelayedEntry> storeEvent) {
                DelayedEntry delayedEntry = storeEvent.getSource();
                Object value = delayedEntry.getValue();
                if (value != null) {
                    return;
                }
                Data key = (Data)storeEvent.getSource().getKey();
                int partitionId = MapContainer.this.mapService.getNodeEngine().getPartitionService().getPartitionId(key);
                PartitionContainer partitionContainer = MapContainer.this.mapService.getPartitionContainer(partitionId);
                RecordStore recordStore = partitionContainer.getExistingRecordStore(MapContainer.this.name);
                if (recordStore != null) {
                    recordStore.removeFromWriteBehindWaitingDeletions(key);
                }
            }
        });
        this.writeBehindQueueManager.start();
    }

    private RecordFactory createRecordFactory(NodeEngine nodeEngine) {
        RecordFactory<Object> recordFactory;
        switch (this.mapConfig.getInMemoryFormat()) {
            case BINARY: {
                recordFactory = new DataRecordFactory(this.mapConfig, nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            case OBJECT: {
                recordFactory = new ObjectRecordFactory(this.mapConfig, nodeEngine.getSerializationService());
                break;
            }
            case OFFHEAP: {
                recordFactory = new OffHeapRecordFactory(this.mapConfig, nodeEngine.getOffHeapStorage(), nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.mapConfig.getInMemoryFormat()));
            }
        }
        return recordFactory;
    }

    public boolean isMapStoreEnabled() {
        MapStoreConfig mapStoreConfig = this.mapConfig.getMapStoreConfig();
        return mapStoreConfig != null && mapStoreConfig.isEnabled();
    }

    private MapStoreWrapper createMapStoreWrapper(MapStoreConfig mapStoreConfig, NodeEngine nodeEngine) {
        MapLoader store;
        try {
            String factoryClassName;
            MapStoreFactory factory = (MapStoreFactory)mapStoreConfig.getFactoryImplementation();
            if (factory == null && (factoryClassName = mapStoreConfig.getFactoryClassName()) != null && !"".equals(factoryClassName)) {
                factory = (MapStoreFactory)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), factoryClassName);
            }
            MapLoader mapLoader = store = factory == null ? mapStoreConfig.getImplementation() : factory.newMapStore(this.name, mapStoreConfig.getProperties());
            if (store == null) {
                String mapStoreClassName = mapStoreConfig.getClassName();
                store = ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), mapStoreClassName);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        MapStoreWrapper storeWrapper = new MapStoreWrapper(store, this.name, mapStoreConfig.isEnabled());
        return storeWrapper;
    }

    private void initMapStore(Object store, MapStoreConfig mapStoreConfig, NodeEngine nodeEngine) {
        if (store instanceof MapLoaderLifecycleSupport) {
            ((MapLoaderLifecycleSupport)store).init(nodeEngine.getHazelcastInstance(), mapStoreConfig.getProperties(), this.name);
        }
        this.loadInitialKeys();
    }

    public void initWanReplication(NodeEngine nodeEngine) {
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationPublisher = wanReplicationService.getWanReplicationPublisher(wanReplicationRefName);
        this.wanMergePolicy = this.mapService.getMergePolicy(wanReplicationRef.getMergePolicy());
    }

    private PartitioningStrategy createPartitioningStrategy() {
        PartitioningStrategy strategy = null;
        PartitioningStrategyConfig partitioningStrategyConfig = this.mapConfig.getPartitioningStrategyConfig();
        if (partitioningStrategyConfig != null && (strategy = partitioningStrategyConfig.getPartitioningStrategy()) == null && partitioningStrategyConfig.getPartitioningStrategyClass() != null) {
            try {
                strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(this.mapService.getNodeEngine().getConfigClassLoader(), partitioningStrategyConfig.getPartitioningStrategyClass());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return strategy;
    }

    public void loadInitialKeys() {
        this.initialKeys.clear();
        Set keys = this.storeWrapper.loadAllKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Object key : keys) {
            Data dataKey = this.mapService.toData(key, this.partitioningStrategy);
            this.initialKeys.put(dataKey, key);
        }
        this.mapService.getNodeEngine().getExecutionService().schedule(new Runnable(){

            @Override
            public void run() {
                MapContainer.this.initialKeys.clear();
            }
        }, 20L, TimeUnit.MINUTES);
    }

    public void shutDownMapStoreScheduledExecutor() {
        this.writeBehindQueueManager.stop();
    }

    public Map<Data, Object> getInitialKeys() {
        return this.initialKeys;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public boolean isWriteBehindMapStoreEnabled() {
        MapStoreConfig mapStoreConfig = this.getMapConfig().getMapStoreConfig();
        return mapStoreConfig != null && mapStoreConfig.isEnabled() && mapStoreConfig.getWriteDelaySeconds() > 0;
    }

    public String addInterceptor(MapInterceptor interceptor) {
        String id = UuidUtil.buildRandomUuidString();
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
        return id;
    }

    public void addInterceptor(String id, MapInterceptor interceptor) {
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
    }

    public List<MapInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, MapInterceptor> getInterceptorMap() {
        return this.interceptorMap;
    }

    public void removeInterceptor(String id) {
        MapInterceptor interceptor = this.interceptorMap.remove(id);
        this.interceptors.remove(interceptor);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNearCacheEnabled() {
        return this.nearCacheEnabled;
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public long getWriteDelayMillis() {
        return TimeUnit.SECONDS.toMillis(this.mapConfig.getMapStoreConfig().getWriteDelaySeconds());
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public MapStoreWrapper getStore() {
        return this.storeWrapper != null && this.storeWrapper.isEnabled() ? this.storeWrapper : null;
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public MapService getMapService() {
        return this.mapService;
    }

    public ReachabilityHandlerChain getReachabilityHandlerChain() {
        return this.reachabilityHandlerChain;
    }

    public WriteBehindManager getWriteBehindManager() {
        return this.writeBehindQueueManager;
    }

    public MapStoreWrapper getStoreWrapper() {
        return this.storeWrapper;
    }

    private class ClearExpiredRecordsTask
    implements Runnable {
        private ClearExpiredRecordsTask() {
        }

        @Override
        public void run() {
            MapService mapService = MapContainer.this.mapService;
            NodeEngine nodeEngine = mapService.getNodeEngine();
            for (int partitionId = 0; partitionId < nodeEngine.getPartitionService().getPartitionCount(); ++partitionId) {
                PartitionContainer partitionContainer;
                InternalPartition partition = nodeEngine.getPartitionService().getPartition(partitionId);
                if (!partition.isOwnerOrBackup(nodeEngine.getThisAddress()) || this.isUninitializedRecordStore(partitionContainer = mapService.getPartitionContainer(partitionId))) continue;
                Operation expirationOperation = MapContainer.this.createExpirationOperation(partitionId);
                OperationService operationService = mapService.getNodeEngine().getOperationService();
                operationService.executeOperation(expirationOperation);
            }
        }

        private boolean isUninitializedRecordStore(PartitionContainer partitionContainer) {
            RecordStore recordStore = partitionContainer.getExistingRecordStore(MapContainer.this.name);
            return recordStore == null;
        }
    }
}

