/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.proxy;

import com.hazelcast.concurrent.lock.LockProxySupport;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.EntryEventFilter;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.NearCache;
import com.hazelcast.map.QueryEventFilter;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AddIndexOperation;
import com.hazelcast.map.operation.AddInterceptorOperation;
import com.hazelcast.map.operation.BasePutOperation;
import com.hazelcast.map.operation.BaseRemoveOperation;
import com.hazelcast.map.operation.ClearOperation;
import com.hazelcast.map.operation.ContainsKeyOperation;
import com.hazelcast.map.operation.ContainsValueOperationFactory;
import com.hazelcast.map.operation.EntryOperation;
import com.hazelcast.map.operation.EvictOperation;
import com.hazelcast.map.operation.GetEntryViewOperation;
import com.hazelcast.map.operation.GetOperation;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.operation.MapEntrySetOperation;
import com.hazelcast.map.operation.MapFlushOperation;
import com.hazelcast.map.operation.MapGetAllOperationFactory;
import com.hazelcast.map.operation.MapIsEmptyOperation;
import com.hazelcast.map.operation.MapKeySetOperation;
import com.hazelcast.map.operation.MapValuesOperation;
import com.hazelcast.map.operation.MultipleEntryOperationFactory;
import com.hazelcast.map.operation.PartitionCheckIfLoadedOperationFactory;
import com.hazelcast.map.operation.PartitionWideEntryOperationFactory;
import com.hazelcast.map.operation.PartitionWideEntryWithPredicateOperationFactory;
import com.hazelcast.map.operation.PutAllOperation;
import com.hazelcast.map.operation.PutIfAbsentOperation;
import com.hazelcast.map.operation.PutOperation;
import com.hazelcast.map.operation.PutTransientOperation;
import com.hazelcast.map.operation.QueryOperation;
import com.hazelcast.map.operation.QueryPartitionOperation;
import com.hazelcast.map.operation.RemoveIfSameOperation;
import com.hazelcast.map.operation.RemoveInterceptorOperation;
import com.hazelcast.map.operation.RemoveOperation;
import com.hazelcast.map.operation.ReplaceIfSameOperation;
import com.hazelcast.map.operation.ReplaceOperation;
import com.hazelcast.map.operation.SetOperation;
import com.hazelcast.map.operation.SizeOperationFactory;
import com.hazelcast.map.operation.TryPutOperation;
import com.hazelcast.map.operation.TryRemoveOperation;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.SortedQueryResultSet;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

abstract class MapProxySupport
extends AbstractDistributedObject<MapService>
implements InitializingObject {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected final String name;
    protected final MapConfig mapConfig;
    protected final LocalMapStatsImpl localMapStats;
    protected final LockProxySupport lockSupport;
    protected final PartitioningStrategy partitionStrategy;

    protected MapProxySupport(String name, MapService service, NodeEngine nodeEngine) {
        super(nodeEngine, service);
        this.name = name;
        this.mapConfig = service.getMapContainer(name).getMapConfig();
        this.partitionStrategy = service.getMapContainer(name).getPartitioningStrategy();
        this.localMapStats = service.getLocalMapStatsImpl(name);
        this.lockSupport = new LockProxySupport(new DefaultObjectNamespace("hz:impl:mapService", name));
    }

    @Override
    public void initialize() {
        this.initializeListeners();
        this.initializeIndexes();
        this.initializeMapStoreLoad();
    }

    private void initializeMapStoreLoad() {
        MapStoreConfig.InitialLoadMode initialLoadMode;
        MapStoreConfig mapStoreConfig = this.mapConfig.getMapStoreConfig();
        if (mapStoreConfig != null && mapStoreConfig.isEnabled() && (initialLoadMode = mapStoreConfig.getInitialLoadMode()).equals((Object)MapStoreConfig.InitialLoadMode.EAGER)) {
            this.waitUntilLoaded();
        }
    }

    private void initializeIndexes() {
        for (MapIndexConfig index : this.mapConfig.getMapIndexConfigs()) {
            if (index.getAttribute() == null) continue;
            this.addIndex(index.getAttribute(), index.isOrdered());
        }
    }

    private void initializeListeners() {
        NodeEngine nodeEngine = this.getNodeEngine();
        List<EntryListenerConfig> listenerConfigs = this.mapConfig.getEntryListenerConfigs();
        for (EntryListenerConfig listenerConfig : listenerConfigs) {
            EntryListener listener = null;
            if (listenerConfig.getImplementation() != null) {
                listener = listenerConfig.getImplementation();
            } else if (listenerConfig.getClassName() != null) {
                try {
                    listener = (EntryListener)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), listenerConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (listener == null) continue;
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            if (listenerConfig.isLocal()) {
                this.addLocalEntryListener(listener);
                continue;
            }
            this.addEntryListenerInternal(listener, null, listenerConfig.isIncludeValue());
        }
    }

    protected Object getInternal(Data key) {
        Object cached;
        MapService mapService = (MapService)this.getService();
        boolean nearCacheEnabled = this.mapConfig.isNearCacheEnabled();
        if (nearCacheEnabled && (cached = mapService.getFromNearCache(this.name, key)) != null) {
            if (NearCache.NULL_OBJECT.equals(cached)) {
                cached = null;
            }
            mapService.interceptAfterGet(this.name, cached);
            return cached;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        if (this.mapConfig.isReadBackupData()) {
            int backupCount = this.mapConfig.getTotalBackupCount();
            InternalPartitionService partitionService = mapService.getNodeEngine().getPartitionService();
            for (int i = 0; i <= backupCount; ++i) {
                Object val;
                int partitionId = partitionService.getPartitionId(key);
                InternalPartition partition = partitionService.getPartition(partitionId);
                if (!nodeEngine.getThisAddress().equals(partition.getReplicaAddress(i)) || (val = mapService.getPartitionContainer(partitionId).getRecordStore(this.name).get(key)) == null) continue;
                mapService.interceptAfterGet(this.name, val);
                return mapService.toData(val);
            }
        }
        GetOperation operation = new GetOperation(this.name, key);
        Data result = (Data)this.invokeOperation(key, operation);
        if (nearCacheEnabled) {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            if (!nodeEngine.getPartitionService().getPartitionOwner(partitionId).equals(nodeEngine.getClusterService().getThisAddress()) || this.mapConfig.getNearCacheConfig().isCacheLocalEntries()) {
                return mapService.putNearCache(this.name, key, result);
            }
        }
        return result;
    }

    protected ICompletableFuture<Data> getAsyncInternal(final Data key) {
        Object cached;
        final NodeEngine nodeEngine = this.getNodeEngine();
        final MapService mapService = (MapService)this.getService();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        final boolean nearCacheEnabled = this.mapConfig.isNearCacheEnabled();
        if (nearCacheEnabled && (cached = mapService.getFromNearCache(this.name, key)) != null) {
            if (NearCache.NULL_OBJECT.equals(cached)) {
                cached = null;
            }
            return new CompletedFuture<Data>(nodeEngine.getSerializationService(), cached, nodeEngine.getExecutionService().getExecutor("hz:async"));
        }
        GetOperation operation = new GetOperation(this.name, key);
        try {
            OperationService operationService = nodeEngine.getOperationService();
            InvocationBuilder invocationBuilder = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false);
            InternalCompletableFuture future = invocationBuilder.invoke();
            future.andThen(new ExecutionCallback<Data>(){

                @Override
                public void onResponse(Data response) {
                    if (nearCacheEnabled) {
                        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
                        if (!nodeEngine.getPartitionService().getPartitionOwner(partitionId).equals(nodeEngine.getClusterService().getThisAddress()) || MapProxySupport.this.mapConfig.getNearCacheConfig().isCacheLocalEntries()) {
                            mapService.putNearCache(MapProxySupport.this.name, key, response);
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Data putInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutOperation operation = new PutOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        Data previousValue = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return previousValue;
    }

    protected boolean tryPutInternal(Data key, Data value, long timeout, TimeUnit timeunit) {
        TryPutOperation operation = new TryPutOperation(this.name, key, value, this.getTimeInMillis(timeout, timeunit));
        boolean putSuccessful = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return putSuccessful;
    }

    protected Data putIfAbsentInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutIfAbsentOperation operation = new PutIfAbsentOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        Data previousValue = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return previousValue;
    }

    protected void putTransientInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutTransientOperation operation = new PutTransientOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
    }

    private Object invokeOperation(Data key, KeyBasedMapOperation operation) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            Object o;
            OperationService operationService = nodeEngine.getOperationService();
            if (this.mapConfig.isStatisticsEnabled()) {
                long time = System.currentTimeMillis();
                InternalCompletableFuture f = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false).invoke();
                o = f.get();
                if (operation instanceof BasePutOperation) {
                    this.localMapStats.incrementPuts(System.currentTimeMillis() - time);
                } else if (operation instanceof BaseRemoveOperation) {
                    this.localMapStats.incrementRemoves(System.currentTimeMillis() - time);
                } else if (operation instanceof GetOperation) {
                    this.localMapStats.incrementGets(System.currentTimeMillis() - time);
                }
            } else {
                InternalCompletableFuture f = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false).invoke();
                o = f.get();
            }
            return o;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected ICompletableFuture<Data> putAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        PutOperation operation = new PutOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            InternalCompletableFuture<Data> future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            this.invalidateNearCache(key);
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected boolean replaceInternal(Data key, Data oldValue, Data newValue) {
        ReplaceIfSameOperation operation = new ReplaceIfSameOperation(this.name, key, oldValue, newValue);
        boolean replaceSuccessful = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return replaceSuccessful;
    }

    protected Data replaceInternal(Data key, Data value) {
        ReplaceOperation operation = new ReplaceOperation(this.name, key, value);
        Data result = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return result;
    }

    protected void setInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        SetOperation operation = new SetOperation(this.name, key, value, timeunit.toMillis(ttl));
        this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
    }

    protected boolean evictInternal(Data key) {
        EvictOperation operation = new EvictOperation(this.name, key, false);
        boolean evictSuccess = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return evictSuccess;
    }

    protected Data removeInternal(Data key) {
        RemoveOperation operation = new RemoveOperation(this.name, key);
        Data previousValue = (Data)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return previousValue;
    }

    protected void deleteInternal(Data key) {
        RemoveOperation operation = new RemoveOperation(this.name, key);
        this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
    }

    protected boolean removeInternal(Data key, Data value) {
        RemoveIfSameOperation operation = new RemoveIfSameOperation(this.name, key, value);
        boolean removed = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return removed;
    }

    protected boolean tryRemoveInternal(Data key, long timeout, TimeUnit timeunit) {
        TryRemoveOperation operation = new TryRemoveOperation(this.name, key, this.getTimeInMillis(timeout, timeunit));
        boolean removed = (Boolean)this.invokeOperation(key, operation);
        this.invalidateNearCache(key);
        return removed;
    }

    protected ICompletableFuture<Data> removeAsyncInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        RemoveOperation operation = new RemoveOperation(this.name, key);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            InternalCompletableFuture<Data> future = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            this.invalidateNearCache(key);
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected boolean containsKeyInternal(Data key) {
        if (this.isKeyInNearCache(key)) {
            return true;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        ContainsKeyOperation containsKeyOperation = new ContainsKeyOperation(this.name, key);
        containsKeyOperation.setServiceName("hz:impl:mapService");
        try {
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", containsKeyOperation, partitionId);
            return (Boolean)((MapService)this.getService()).toObject(f.get());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void waitUntilLoaded() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new PartitionCheckIfLoadedOperationFactory(this.name));
            Iterator<Map.Entry<Integer, Object>> iterator = results.entrySet().iterator();
            boolean isFinished = false;
            HashSet<Integer> retrySet = new HashSet<Integer>();
            while (!isFinished) {
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Object> entry = iterator.next();
                    if (Boolean.TRUE.equals(entry.getValue())) {
                        iterator.remove();
                        continue;
                    }
                    retrySet.add(entry.getKey());
                }
                if (retrySet.size() > 0) {
                    results = this.retryPartitions(retrySet);
                    iterator = results.entrySet().iterator();
                    Thread.sleep(1000L);
                    retrySet.clear();
                    continue;
                }
                isFinished = true;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private Map<Integer, Object> retryPartitions(Collection partitions) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnPartitions("hz:impl:mapService", new PartitionCheckIfLoadedOperationFactory(this.name), partitions);
            return results;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public int size() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new SizeOperationFactory(this.name));
            int total = 0;
            for (Object result : results.values()) {
                Integer size = (Integer)((MapService)this.getService()).toObject(result);
                total += size.intValue();
            }
            return total;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean containsValueInternal(Data dataValue) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new ContainsValueOperationFactory(this.name, dataValue));
            for (Object result : results.values()) {
                Boolean contains = (Boolean)((MapService)this.getService()).toObject(result);
                if (!contains.booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean isEmpty() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapIsEmptyOperation(this.name), nodeEngine));
            for (Object result : results.values()) {
                if (((Boolean)((MapService)this.getService()).toObject(result)).booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Map<Object, Object> getAllObjectInternal(Set<Data> keys) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        boolean nearCacheEnabled = this.mapConfig.isNearCacheEnabled();
        if (nearCacheEnabled) {
            Iterator<Data> iterator = keys.iterator();
            while (iterator.hasNext()) {
                Data key = iterator.next();
                Object cachedValue = mapService.getFromNearCache(this.name, key);
                if (cachedValue == null) continue;
                if (!NearCache.NULL_OBJECT.equals(cachedValue)) {
                    result.put(mapService.toObject(key), mapService.toObject(cachedValue));
                }
                iterator.remove();
            }
        }
        if (keys.isEmpty()) {
            return result;
        }
        Collection<Integer> partitions = this.getPartitionsForKeys(keys);
        try {
            Map<Integer, Object> responses = nodeEngine.getOperationService().invokeOnPartitions("hz:impl:mapService", new MapGetAllOperationFactory(this.name, keys), partitions);
            for (Object response : responses.values()) {
                Set<Map.Entry<Data, Data>> entries = ((MapEntrySet)mapService.toObject(response)).getEntrySet();
                for (Map.Entry<Data, Data> entry : entries) {
                    result.put(mapService.toObject(entry.getKey()), mapService.toObject(entry.getValue()));
                    if (!nearCacheEnabled) continue;
                    int partitionId = nodeEngine.getPartitionService().getPartitionId(entry.getKey());
                    if (nodeEngine.getPartitionService().getPartitionOwner(partitionId).equals(nodeEngine.getClusterService().getThisAddress()) && !this.mapConfig.getNearCacheConfig().isCacheLocalEntries()) continue;
                    mapService.putNearCache(this.name, entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return result;
    }

    private Collection<Integer> getPartitionsForKeys(Set<Data> keys) {
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        int partitions = partitionService.getPartitionCount();
        int capacity = Math.min(partitions, keys.size());
        HashSet<Integer> partitionIds = new HashSet<Integer>(capacity);
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext() && partitionIds.size() < partitions) {
            Data key = iterator.next();
            partitionIds.add(partitionService.getPartitionId(key));
        }
        return partitionIds;
    }

    protected void putAllInternal(Map<? extends Object, ? extends Object> entries) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        int factor = 3;
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        OperationService operationService = nodeEngine.getOperationService();
        int partitionCount = partitionService.getPartitionCount();
        boolean tooManyEntries = entries.size() > partitionCount * factor;
        try {
            if (tooManyEntries) {
                LinkedList futures = new LinkedList();
                HashMap<Integer, MapEntrySet> entryMap = new HashMap<Integer, MapEntrySet>(nodeEngine.getPartitionService().getPartitionCount());
                for (Map.Entry<? extends Object, ? extends Object> entry : entries.entrySet()) {
                    if (entry.getKey() == null) {
                        throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
                    }
                    if (entry.getValue() == null) {
                        throw new NullPointerException(NULL_VALUE_IS_NOT_ALLOWED);
                    }
                    int partitionId = partitionService.getPartitionId(entry.getKey());
                    if (!entryMap.containsKey(partitionId)) {
                        entryMap.put(partitionId, new MapEntrySet());
                    }
                    ((MapEntrySet)entryMap.get(partitionId)).add(new AbstractMap.SimpleImmutableEntry<Data, Data>(mapService.toData(entry.getKey(), this.partitionStrategy), mapService.toData(entry.getValue())));
                }
                for (Map.Entry<Object, Object> entry : entryMap.entrySet()) {
                    Integer partitionId = (Integer)entry.getKey();
                    PutAllOperation op = new PutAllOperation(this.name, (MapEntrySet)entry.getValue());
                    op.setPartitionId(partitionId);
                    futures.add(operationService.invokeOnPartition("hz:impl:mapService", op, partitionId));
                }
                for (Future future : futures) {
                    future.get();
                }
            } else {
                for (Map.Entry<? extends Object, ? extends Object> entry : entries.entrySet()) {
                    if (entry.getKey() == null) {
                        throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
                    }
                    if (entry.getValue() == null) {
                        throw new NullPointerException(NULL_VALUE_IS_NOT_ALLOWED);
                    }
                    this.putInternal(mapService.toData(entry.getKey(), this.partitionStrategy), mapService.toData(entry.getValue()), -1L, TimeUnit.SECONDS);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected Set<Data> keySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapKeySetOperation(this.name), nodeEngine));
            HashSet<Data> keySet = new HashSet<Data>();
            for (Object result : results.values()) {
                Set<Data> keys = ((MapKeySet)((MapService)this.getService()).toObject(result)).getKeySet();
                keySet.addAll(keys);
            }
            return keySet;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Set<Data> localKeySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        HashSet<Data> keySet = new HashSet<Data>();
        try {
            List<Integer> memberPartitions = nodeEngine.getPartitionService().getMemberPartitions(nodeEngine.getThisAddress());
            for (Integer memberPartition : memberPartitions) {
                RecordStore recordStore = mapService.getRecordStore(memberPartition, this.name);
                keySet.addAll(recordStore.getReadonlyRecordMap().keySet());
            }
            return keySet;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void flush() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapFlushOperation(this.name), nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Collection<Data> valuesInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapValuesOperation(this.name), nodeEngine));
            ArrayList<Data> values = new ArrayList<Data>();
            for (Object result : results.values()) {
                values.addAll(((MapValueCollection)((MapService)this.getService()).toObject(result)).getValues());
            }
            return values;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void clearInternal() {
        String mapName = this.name;
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            ClearOperation clearOperation = new ClearOperation(mapName);
            clearOperation.setServiceName("hz:impl:mapService");
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(clearOperation, nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public String addMapInterceptorInternal(MapInterceptor interceptor) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        if (interceptor instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)interceptor)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
        }
        String id = mapService.addInterceptor(this.name, interceptor);
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            try {
                if (member.localMember()) continue;
                InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnTarget("hz:impl:mapService", new AddInterceptorOperation(id, interceptor, this.name), member.getAddress());
                f.get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return id;
    }

    public void removeMapInterceptorInternal(String id) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        mapService.removeInterceptor(this.name, id);
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        for (Member member : members) {
            try {
                if (member.localMember()) continue;
                MemberImpl memberImpl = (MemberImpl)member;
                InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnTarget("hz:impl:mapService", new RemoveInterceptorOperation(this.name, id), memberImpl.getAddress());
                f.get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    public String addLocalEntryListener(EntryListener listener) {
        MapService mapService = (MapService)this.getService();
        return mapService.addLocalEventListener(listener, this.name);
    }

    public String addLocalEntryListenerInternal(EntryListener listener, Predicate predicate, Data key, boolean includeValue) {
        MapService mapService = (MapService)this.getService();
        QueryEventFilter eventFilter = new QueryEventFilter(includeValue, key, predicate);
        return mapService.addLocalEventListener(listener, eventFilter, this.name);
    }

    protected String addEntryListenerInternal(EntryListener listener, Data key, boolean includeValue) {
        EntryEventFilter eventFilter = new EntryEventFilter(includeValue, key);
        MapService mapService = (MapService)this.getService();
        return mapService.addEventListener(listener, eventFilter, this.name);
    }

    protected String addEntryListenerInternal(EntryListener listener, Predicate predicate, Data key, boolean includeValue) {
        QueryEventFilter eventFilter = new QueryEventFilter(includeValue, key, predicate);
        MapService mapService = (MapService)this.getService();
        return mapService.addEventListener(listener, eventFilter, this.name);
    }

    protected boolean removeEntryListenerInternal(String id) {
        MapService mapService = (MapService)this.getService();
        return mapService.removeEventListener(this.name, id);
    }

    protected EntryView getEntryViewInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        GetEntryViewOperation getEntryViewOperation = new GetEntryViewOperation(this.name, key);
        getEntryViewOperation.setServiceName("hz:impl:mapService");
        try {
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", getEntryViewOperation, partitionId);
            Object o = ((MapService)this.getService()).toObject(f.get());
            return (EntryView)o;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Set<Map.Entry<Data, Data>> entrySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapEntrySetOperation(this.name), nodeEngine));
            HashSet<Map.Entry<Data, Data>> entrySet = new HashSet<Map.Entry<Data, Data>>();
            for (Object result : results.values()) {
                Set<Map.Entry<Data, Data>> entries = ((MapEntrySet)((MapService)this.getService()).toObject(result)).getEntrySet();
                if (entries == null) continue;
                entrySet.addAll(entries);
            }
            return entrySet;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Data executeOnKeyInternal(Data key, EntryProcessor entryProcessor) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        EntryOperation operation = new EntryOperation(this.name, key, entryProcessor);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            InternalCompletableFuture future = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setResultDeserialized(false).invoke();
            Data data = (Data)future.get();
            this.invalidateNearCache(key);
            return data;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Map executeOnKeysInternal(Set<Data> keys, EntryProcessor entryProcessor) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        NodeEngine nodeEngine = this.getNodeEngine();
        Collection<Integer> partitionsForKeys = this.getPartitionsForKeys(keys);
        try {
            MultipleEntryOperationFactory operationFactory = new MultipleEntryOperationFactory(this.name, keys, entryProcessor);
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnPartitions("hz:impl:mapService", operationFactory, partitionsForKeys);
            for (Object o : results.values()) {
                if (o == null) continue;
                MapService service = (MapService)this.getService();
                MapEntrySet mapEntrySet = (MapEntrySet)o;
                for (Map.Entry<Data, Data> entry : mapEntrySet.getEntrySet()) {
                    result.put(service.toObject(entry.getKey()), service.toObject(entry.getValue()));
                }
            }
            this.invalidateNearCache(keys);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    public ICompletableFuture executeOnKeyInternal(Data key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        EntryOperation operation = new EntryOperation(this.name, key, entryProcessor);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            if (callback == null) {
                return nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            }
            InternalCompletableFuture future = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).setCallback(new MapExecutionCallbackAdapter(callback)).invoke();
            this.invalidateNearCache(key);
            return future;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Map executeOnEntries(EntryProcessor entryProcessor) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        try {
            NodeEngine nodeEngine = this.getNodeEngine();
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new PartitionWideEntryOperationFactory(this.name, entryProcessor));
            for (Object o : results.values()) {
                if (o == null) continue;
                MapService service = (MapService)this.getService();
                MapEntrySet mapEntrySet = (MapEntrySet)o;
                for (Map.Entry<Data, Data> entry : mapEntrySet.getEntrySet()) {
                    Data key = entry.getKey();
                    result.put(service.toObject(entry.getKey()), service.toObject(entry.getValue()));
                    this.invalidateNearCache(key);
                }
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    public Map executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        try {
            NodeEngine nodeEngine = this.getNodeEngine();
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new PartitionWideEntryWithPredicateOperationFactory(this.name, entryProcessor, predicate));
            for (Object o : results.values()) {
                if (o == null) continue;
                MapService service = (MapService)this.getService();
                MapEntrySet mapEntrySet = (MapEntrySet)o;
                for (Map.Entry<Data, Data> entry : mapEntrySet.getEntrySet()) {
                    Data key = entry.getKey();
                    result.put(service.toObject(key), service.toObject(entry.getValue()));
                    this.invalidateNearCache(key);
                }
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    protected Set queryLocal(Predicate predicate, IterationType iterationType, boolean dataResult) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        SerializationService ss = nodeEngine.getSerializationService();
        List<Integer> partitionIds = nodeEngine.getPartitionService().getMemberPartitions(nodeEngine.getThisAddress());
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(iterationType);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.query(pagingPredicate, iterationType, dataResult);
                pagingPredicate.nextPage();
            }
        }
        AbstractSet result = pagingPredicate == null ? new QueryResultSet(ss, iterationType, dataResult) : new SortedQueryResultSet(pagingPredicate.getComparator(), iterationType, pagingPredicate.getPageSize());
        List<Object> returnedPartitionIds = new ArrayList();
        try {
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:mapService", new QueryOperation(this.name, predicate), nodeEngine.getThisAddress());
            QueryResult queryResult = (QueryResult)future.get();
            if (queryResult != null) {
                returnedPartitionIds = queryResult.getPartitionIds();
                if (pagingPredicate == null) {
                    result.addAll(queryResult.getResult());
                } else {
                    for (QueryResultEntry queryResultEntry : queryResult.getResult()) {
                        Object key = ss.toObject(queryResultEntry.getKeyData());
                        Object t = ss.toObject(queryResultEntry.getValueData());
                        result.add(new AbstractMap.SimpleImmutableEntry(key, t));
                    }
                }
            }
            if (returnedPartitionIds.size() == partitionIds.size()) {
                if (pagingPredicate != null) {
                    PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, ((SortedQueryResultSet)result).last());
                }
                return result;
            }
            ArrayList<Integer> missingList = new ArrayList<Integer>();
            for (Integer partitionId : partitionIds) {
                if (returnedPartitionIds.contains(partitionId)) continue;
                missingList.add(partitionId);
            }
            ArrayList futures = new ArrayList(missingList.size());
            for (Integer n : missingList) {
                QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
                queryPartitionOperation.setPartitionId(n);
                try {
                    InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, n);
                    futures.add(f);
                }
                catch (Throwable t) {
                    throw ExceptionUtil.rethrow(t);
                }
            }
            for (Future future2 : futures) {
                QueryResult qResult = (QueryResult)future2.get();
                if (pagingPredicate == null) {
                    result.addAll(qResult.getResult());
                    continue;
                }
                for (QueryResultEntry queryResultEntry : qResult.getResult()) {
                    Object key = ss.toObject(queryResultEntry.getKeyData());
                    Object value = ss.toObject(queryResultEntry.getValueData());
                    result.add(new AbstractMap.SimpleImmutableEntry(key, value));
                }
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    protected Set query(Predicate predicate, IterationType iterationType, boolean dataResult) {
        int i;
        QueryResult queryResult;
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        SerializationService ss = nodeEngine.getSerializationService();
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        HashSet<Integer> plist = new HashSet<Integer>(partitionCount);
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(iterationType);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.query(pagingPredicate, iterationType, dataResult);
                pagingPredicate.nextPage();
            }
        }
        AbstractSet result = pagingPredicate == null ? new QueryResultSet(ss, iterationType, dataResult) : new SortedQueryResultSet(pagingPredicate.getComparator(), iterationType, pagingPredicate.getPageSize());
        ArrayList<Integer> missingList = new ArrayList<Integer>();
        try {
            ArrayList flist = new ArrayList();
            for (MemberImpl memberImpl : members) {
                InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:mapService", new QueryOperation(this.name, predicate), memberImpl.getAddress());
                flist.add(future);
            }
            for (Future future : flist) {
                List<Integer> partitionIds;
                queryResult = (QueryResult)future.get();
                if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null) continue;
                plist.addAll(partitionIds);
                if (pagingPredicate == null) {
                    result.addAll(queryResult.getResult());
                    continue;
                }
                for (QueryResultEntry queryResultEntry : queryResult.getResult()) {
                    Object key = ss.toObject(queryResultEntry.getKeyData());
                    Object value = ss.toObject(queryResultEntry.getValueData());
                    result.add(new AbstractMap.SimpleImmutableEntry(key, value));
                }
            }
            if (plist.size() == partitionCount) {
                if (pagingPredicate != null) {
                    PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, ((SortedQueryResultSet)result).last());
                }
                return result;
            }
            for (i = 0; i < partitionCount; ++i) {
                if (plist.contains(i)) continue;
                missingList.add(i);
            }
        }
        catch (Throwable t) {
            missingList.clear();
            for (i = 0; i < partitionCount; ++i) {
                if (plist.contains(i)) continue;
                missingList.add(i);
            }
        }
        try {
            ArrayList futures = new ArrayList(missingList.size());
            for (Integer n : missingList) {
                QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
                queryPartitionOperation.setPartitionId(n);
                try {
                    InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, n);
                    futures.add(f);
                }
                catch (Throwable t) {
                    throw ExceptionUtil.rethrow(t);
                }
            }
            for (Future future : futures) {
                queryResult = (QueryResult)future.get();
                if (pagingPredicate == null) {
                    result.addAll(queryResult.getResult());
                    continue;
                }
                for (QueryResultEntry queryResultEntry : queryResult.getResult()) {
                    Object key = ss.toObject(queryResultEntry.getKeyData());
                    Object value = ss.toObject(queryResultEntry.getValueData());
                    result.add(new AbstractMap.SimpleImmutableEntry(key, value));
                }
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        if (pagingPredicate != null) {
            PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, ((SortedQueryResultSet)result).last());
        }
        return result;
    }

    public void addIndex(String attribute, boolean ordered) {
        NodeEngine nodeEngine = this.getNodeEngine();
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        try {
            AddIndexOperation addIndexOperation = new AddIndexOperation(this.name, attribute, ordered);
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(addIndexOperation, nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public LocalMapStats getLocalMapStats() {
        return ((MapService)this.getService()).createLocalMapStats(this.name);
    }

    private boolean isKeyInNearCache(Data key) {
        Object cached;
        MapService mapService = (MapService)this.getService();
        boolean nearCacheEnabled = this.mapConfig.isNearCacheEnabled();
        return nearCacheEnabled && (cached = mapService.getFromNearCache(this.name, key)) != null && !cached.equals(NearCache.NULL_OBJECT);
    }

    private void invalidateNearCache(Data key) {
        if (key == null) {
            return;
        }
        ((MapService)this.getService()).invalidateNearCache(this.name, key);
    }

    private void invalidateNearCache(Set<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        ((MapService)this.getService()).invalidateNearCache(this.name, keys);
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    private class MapExecutionCallbackAdapter
    implements Callback {
        private final ExecutionCallback executionCallback;

        public MapExecutionCallbackAdapter(ExecutionCallback executionCallback) {
            this.executionCallback = executionCallback;
        }

        public void notify(Object response) {
            if (response instanceof Throwable) {
                this.executionCallback.onFailure((Throwable)response);
            } else {
                this.executionCallback.onResponse(((MapService)MapProxySupport.this.getService()).toObject(response));
            }
        }
    }
}

