/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.AbstractBaseRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.serialization.Data;

abstract class AbstractRecord<V>
extends AbstractBaseRecord<V> {
    protected Data key;

    public AbstractRecord(Data key) {
        this.key = key;
    }

    public AbstractRecord() {
    }

    @Override
    public final Data getKey() {
        return this.key;
    }

    @Override
    public RecordStatistics getStatistics() {
        return null;
    }

    @Override
    public void setStatistics(RecordStatistics stats) {
    }

    @Override
    public void onAccess() {
        this.lastAccessTime = System.nanoTime();
    }

    @Override
    public void onStore() {
    }

    @Override
    public void onUpdate() {
        this.lastUpdateTime = System.nanoTime();
        ++this.version;
    }

    @Override
    public Object getCachedValue() {
        return Record.NOT_CACHED;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
    }

    @Override
    public long getCost() {
        long size = super.getCost();
        int objectReferenceInBytes = 4;
        return size += (long)(4 + this.key.getHeapCost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRecord that = (AbstractRecord)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "Record{key=" + this.key + '}';
    }
}

