/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.map.writebehind.ArrayWriteBehindQueue;
import com.hazelcast.map.writebehind.ReachedMaxSizeException;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class BoundedArrayWriteBehindQueue<T>
extends ArrayWriteBehindQueue<T> {
    private static final int DEFAULT_MAX_SIZE = 2048;
    private final int maxSize;

    BoundedArrayWriteBehindQueue() {
        this(2048);
    }

    BoundedArrayWriteBehindQueue(List<T> list, int maxSize) {
        super(list);
        this.maxSize = maxSize;
    }

    BoundedArrayWriteBehindQueue(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Queue max size should be greater than 0 but found [" + maxSize + "]");
        }
        this.maxSize = maxSize;
    }

    @Override
    public boolean offer(T t) {
        int currentSize = this.size();
        if (this.hasReachedMaxSize(currentSize)) {
            throw new ReachedMaxSizeException("Queue already reached max capacity [" + this.maxSize + "]");
        }
        return super.offer(t);
    }

    @Override
    public WriteBehindQueue<T> getSnapShot() {
        if (this.list == null || this.list.isEmpty()) {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }
        return new BoundedArrayWriteBehindQueue(new ArrayList(this.list), this.maxSize);
    }

    @Override
    public void addFront(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int currentSize = this.size();
        int desiredSize = currentSize + collection.size();
        if (this.hasReachedMaxSize(desiredSize)) {
            throw new ReachedMaxSizeException("Remaining empty slots are not appropriate for this collection. Remaining = [" + (this.maxSize - currentSize) + "]");
        }
        super.addFront(collection);
    }

    @Override
    public void addEnd(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int currentSize = this.size();
        int desiredSize = currentSize + collection.size();
        if (this.hasReachedMaxSize(desiredSize)) {
            throw new ReachedMaxSizeException("Remaining empty slots are not appropriate for this collection. Remaining = [" + (this.maxSize - currentSize) + "]");
        }
        super.addEnd(collection);
    }

    private boolean hasReachedMaxSize(int size) {
        return size >= this.maxSize;
    }
}

