/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.map.writebehind.ArrayWriteBehindQueue;
import com.hazelcast.map.writebehind.BoundedArrayWriteBehindQueue;
import com.hazelcast.map.writebehind.SynchronizedWriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class WriteBehindQueues {
    private WriteBehindQueues() {
    }

    public static <T> WriteBehindQueue<T> createArrayWriteBehindQueue() {
        return new ArrayWriteBehindQueue();
    }

    public static <T> WriteBehindQueue<T> createBoundedArrayWriteBehindQueue() {
        return new BoundedArrayWriteBehindQueue();
    }

    public static <T> WriteBehindQueue<T> createDefaultWriteBehindQueue(boolean isWriteBehindEnabled) {
        return isWriteBehindEnabled ? WriteBehindQueues.createSafeWriteBehindQueue(WriteBehindQueues.<T>createBoundedArrayWriteBehindQueue()) : WriteBehindQueues.emptyWriteBehindQueue();
    }

    public static <T> WriteBehindQueue<T> emptyWriteBehindQueue() {
        return EmptyWriteBehindQueueHolder.EMPTY_WRITE_BEHIND_QUEUE;
    }

    public static <T> WriteBehindQueue<T> createSafeWriteBehindQueue(WriteBehindQueue<T> queue) {
        return new SynchronizedWriteBehindQueue<T>(queue);
    }

    private static final class EmptyWriteBehindQueue
    implements WriteBehindQueue {
        private EmptyWriteBehindQueue() {
        }

        public boolean offer(Object o) {
            return false;
        }

        @Override
        public void removeFirst() {
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        public boolean contains(Object o) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        public WriteBehindQueue getSnapShot() {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }

        public void addFront(Collection collection) {
        }

        public void addEnd(Collection collection) {
        }

        public List fetchAndRemoveAll() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        public List asList() {
            return Collections.emptyList();
        }

        @Override
        public void shrink() {
        }
    }

    private static final class EmptyWriteBehindQueueHolder {
        private static final WriteBehindQueue EMPTY_WRITE_BEHIND_QUEUE = new EmptyWriteBehindQueue();

        private EmptyWriteBehindQueueHolder() {
        }
    }
}

