/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.record;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.monitor.impl.LocalReplicatedMapStatsImpl;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.replicatedmap.CleanerRegistrator;
import com.hazelcast.replicatedmap.ReplicatedMapEvictionProcessor;
import com.hazelcast.replicatedmap.ReplicatedMapService;
import com.hazelcast.replicatedmap.record.InternalReplicatedMapStorage;
import com.hazelcast.replicatedmap.record.ReplicatedRecord;
import com.hazelcast.replicatedmap.record.ReplicatedRecordStore;
import com.hazelcast.replicatedmap.record.ReplicationPublisher;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.EntryTaskSchedulerFactory;
import com.hazelcast.util.scheduler.ScheduleType;
import com.hazelcast.util.scheduler.ScheduledEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;

abstract class AbstractBaseReplicatedRecordStore<K, V>
implements ReplicatedRecordStore,
InitializingObject {
    protected final LocalReplicatedMapStatsImpl mapStats = new LocalReplicatedMapStatsImpl();
    protected final InternalReplicatedMapStorage<K, V> storage;
    protected final ReplicatedMapService replicatedMapService;
    protected final ReplicationPublisher replicationPublisher;
    protected final ReplicatedMapConfig replicatedMapConfig;
    protected final NodeEngine nodeEngine;
    protected final int localMemberHash;
    protected final Member localMember;
    private final EntryTaskScheduler ttlEvictionScheduler;
    private final ScheduledFuture<?> cleanerFuture;
    private final EventService eventService;
    private final Object[] mutexes;
    private final String name;

    protected AbstractBaseReplicatedRecordStore(String name, NodeEngine nodeEngine, CleanerRegistrator cleanerRegistrator, ReplicatedMapService replicatedMapService) {
        this.name = name;
        this.nodeEngine = nodeEngine;
        this.localMember = nodeEngine.getLocalMember();
        this.eventService = nodeEngine.getEventService();
        this.localMemberHash = this.localMember.getUuid().hashCode();
        this.replicatedMapService = replicatedMapService;
        this.replicatedMapConfig = replicatedMapService.getReplicatedMapConfig(name);
        this.storage = new InternalReplicatedMapStorage(this.replicatedMapConfig);
        this.replicationPublisher = new ReplicationPublisher(this, nodeEngine);
        this.ttlEvictionScheduler = EntryTaskSchedulerFactory.newScheduler(nodeEngine.getExecutionService().getDefaultScheduledExecutor(), new ReplicatedMapEvictionProcessor(nodeEngine, replicatedMapService, name), ScheduleType.POSTPONE);
        this.mutexes = new Object[this.replicatedMapConfig.getConcurrencyLevel()];
        for (int i = 0; i < this.mutexes.length; ++i) {
            this.mutexes[i] = new Object();
        }
        this.cleanerFuture = cleanerRegistrator.registerCleaner(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initialize() {
        this.initializeListeners();
        ArrayList<MemberImpl> members = new ArrayList<MemberImpl>(this.nodeEngine.getClusterService().getMemberList());
        members.remove(this.localMember);
        if (members.size() == 0) {
            this.storage.finishLoading();
        } else {
            this.replicationPublisher.sendPreProvisionRequest(members);
        }
    }

    @Override
    public void destroy() {
        if (this.cleanerFuture.isCancelled()) {
            return;
        }
        this.cleanerFuture.cancel(true);
        this.replicationPublisher.destroy();
        this.storage.clear();
        this.replicatedMapService.destroyDistributedObject(this.getName());
    }

    @Override
    public ReplicationPublisher<K, V> getReplicationPublisher() {
        return this.replicationPublisher;
    }

    public LocalReplicatedMapStats createReplicatedMapStats() {
        LocalReplicatedMapStatsImpl stats = this.mapStats;
        stats.setOwnedEntryCount(this.storage.size());
        ArrayList<ReplicatedRecord<K, V>> records = new ArrayList<ReplicatedRecord<K, V>>(this.storage.values());
        long hits = 0L;
        for (ReplicatedRecord replicatedRecord : records) {
            stats.setLastAccessTime(replicatedRecord.getLastAccessTime());
            stats.setLastUpdateTime(replicatedRecord.getUpdateTime());
            hits += replicatedRecord.getHits();
        }
        stats.setHits(hits);
        return stats;
    }

    public LocalReplicatedMapStatsImpl getReplicatedMapStats() {
        return this.mapStats;
    }

    public void finalChunkReceived() {
        this.storage.finishLoading();
    }

    public boolean isLoaded() {
        return this.storage.isLoaded();
    }

    public int getLocalMemberHash() {
        return this.localMemberHash;
    }

    public ReplicatedMapService getReplicatedMapService() {
        return this.replicatedMapService;
    }

    public Set<ReplicatedRecord> getRecords() {
        this.storage.checkState();
        return new HashSet<ReplicatedRecord>(this.storage.values());
    }

    protected Object getMutex(Object key) {
        return this.mutexes[key.hashCode() != Integer.MIN_VALUE ? Math.abs(key.hashCode()) % this.mutexes.length : 0];
    }

    ScheduledEntry<K, V> cancelTtlEntry(K key) {
        return this.ttlEvictionScheduler.cancel(key);
    }

    boolean scheduleTtlEntry(long delayMillis, K key, V object) {
        return this.ttlEvictionScheduler.schedule(delayMillis, key, object);
    }

    void fireEntryListenerEvent(Object key, Object oldValue, Object value) {
        EntryEventType eventType = value == null ? EntryEventType.REMOVED : (oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED);
        EntryEvent<Object, Object> event = new EntryEvent<Object, Object>(this.getName(), this.localMember, eventType.getType(), key, oldValue, value);
        Collection<EventRegistration> registrations = this.eventService.getRegistrations("hz:impl:replicatedMapService", this.getName());
        if (registrations.size() > 0) {
            this.eventService.publishEvent("hz:impl:replicatedMapService", registrations, event, this.getName().hashCode());
        }
    }

    private void initializeListeners() {
        List<ListenerConfig> listenerConfigs = this.replicatedMapConfig.getListenerConfigs();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            EntryListener listener = null;
            if (listenerConfig.getImplementation() != null) {
                listener = (EntryListener)listenerConfig.getImplementation();
            } else if (listenerConfig.getClassName() != null) {
                try {
                    listener = (EntryListener)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), listenerConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (listener == null) continue;
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(this.nodeEngine.getHazelcastInstance());
            }
            this.addEntryListener(listener, null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBaseReplicatedRecordStore that = (AbstractBaseReplicatedRecordStore)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.storage.equals(that.storage);
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

