/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.record;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.record.VectorClock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ReplicatedRecord<K, V>
implements IdentifiedDataSerializable {
    private static final AtomicLongFieldUpdater<ReplicatedRecord> HITS_UPDATER = AtomicLongFieldUpdater.newUpdater(ReplicatedRecord.class, "hits");
    private static final AtomicLongFieldUpdater<ReplicatedRecord> LAST_ACCESS_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(ReplicatedRecord.class, "hits");
    private volatile long hits;
    private volatile long lastAccessTime;
    private K key;
    private V value;
    private VectorClock vectorClock;
    private int latestUpdateHash;
    private long ttlMillis;
    private volatile long updateTime = System.currentTimeMillis();

    public ReplicatedRecord() {
    }

    public ReplicatedRecord(K key, V value, VectorClock vectorClock, int hash, long ttlMillis) {
        this.key = key;
        this.value = value;
        this.vectorClock = vectorClock;
        this.latestUpdateHash = hash;
        this.ttlMillis = ttlMillis;
    }

    public K getKey() {
        this.access();
        return this.key;
    }

    public V getValue() {
        this.access();
        return this.value;
    }

    public VectorClock getVectorClock() {
        return this.vectorClock;
    }

    public long getTtlMillis() {
        return this.ttlMillis;
    }

    public V setValue(V value, int hash, long ttlMillis) {
        this.access();
        V oldValue = this.value;
        this.value = value;
        this.latestUpdateHash = hash;
        this.updateTime = System.currentTimeMillis();
        this.ttlMillis = ttlMillis;
        return oldValue;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public int getLatestUpdateHash() {
        return this.latestUpdateHash;
    }

    public long getHits() {
        return this.hits;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void access() {
        HITS_UPDATER.incrementAndGet(this);
        LAST_ACCESS_TIME_UPDATER.set(this, System.currentTimeMillis());
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.value);
        this.vectorClock.writeData(out);
        out.writeInt(this.latestUpdateHash);
        out.writeLong(this.ttlMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readObject();
        this.value = in.readObject();
        this.vectorClock = new VectorClock();
        this.vectorClock.readData(in);
        this.latestUpdateHash = in.readInt();
        this.ttlMillis = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedRecord that = (ReplicatedRecord)o;
        if (this.latestUpdateHash != that.latestUpdateHash) {
            return false;
        }
        if (this.ttlMillis != that.ttlMillis) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.latestUpdateHash;
        result = 31 * result + (int)(this.ttlMillis ^ this.ttlMillis >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicatedRecord{");
        sb.append("key=").append(this.key);
        sb.append(", value=").append(this.value);
        sb.append(", vector=").append(this.vectorClock);
        sb.append(", latestUpdateHash=").append(this.latestUpdateHash);
        sb.append(", ttlMillis=").append(this.ttlMillis);
        sb.append('}');
        return sb.toString();
    }
}

