/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientDisconnectionOperation;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataAdapter;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.CoreService;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.util.executor.ExecutorType;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class ClientEngineImpl
implements ClientEngine,
CoreService,
ManagedService,
MembershipAwareService,
EventPublishingService<ClientEndpoint, ClientListener> {
    public static final String SERVICE_NAME = "hz:core:clientEngine";
    private static final int DESTROY_ENDPOINT_DELAY_MS = 1111;
    private static final int ENDPOINT_REMOVE_DELAY_MS = 10;
    private static final int THREADS_PER_CORE = 10;
    private static final int EXECUTOR_QUEUE_CAPACITY_PER_CORE = 100000;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final Executor executor;
    private final SerializationService serializationService;
    private final ClientEndpointManager endpointManager;
    private final ILogger logger;
    private final ConnectionListener connectionListener = new ConnectionListenerImpl();

    public ClientEngineImpl(Node node) {
        this.node = node;
        this.serializationService = node.getSerializationService();
        this.nodeEngine = node.nodeEngine;
        this.endpointManager = new ClientEndpointManager(this);
        int coreSize = Runtime.getRuntime().availableProcessors();
        this.executor = this.nodeEngine.getExecutionService().register("hz:client", coreSize * 10, coreSize * 100000, ExecutorType.CONCRETE);
        this.logger = node.getLogger(ClientEngine.class);
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public int getClientEndpointCount() {
        return this.endpointManager.size();
    }

    public void handlePacket(ClientPacket packet) {
        this.executor.execute(new ClientPacketProcessor(packet));
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.nodeEngine.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.nodeEngine.getClusterService();
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public ProxyService getProxyService() {
        return this.nodeEngine.getProxyService();
    }

    void sendResponse(ClientEndpoint endpoint, Object response, int callId, boolean isError, boolean isEvent) {
        Data data = this.serializationService.toData(response);
        ClientResponse clientResponse = new ClientResponse(data, callId, isError, isEvent);
        this.sendResponse(endpoint, clientResponse);
    }

    private void sendResponse(ClientEndpoint endpoint, ClientResponse response) {
        Data resultData = this.serializationService.toData(response);
        Connection conn = endpoint.getConnection();
        conn.write(new DataAdapter(resultData, this.serializationService.getPortableContext()));
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.nodeEngine.getTransactionManagerService();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    public ClientEndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    void destroyEndpoint(ClientEndpoint endpoint, boolean closeImmediately) {
        if (endpoint != null) {
            this.logger.info("Destroying " + endpoint);
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.warning(e);
            }
            final Connection connection = endpoint.getConnection();
            if (closeImmediately) {
                try {
                    connection.close();
                }
                catch (Throwable e) {
                    this.logger.warning("While closing client connection: " + connection, e);
                }
            } else {
                this.nodeEngine.getExecutionService().schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (connection.live()) {
                            try {
                                connection.close();
                            }
                            catch (Throwable e) {
                                ClientEngineImpl.this.logger.warning("While closing client connection: " + e.toString());
                            }
                        }
                    }
                }, 1111L, TimeUnit.MILLISECONDS);
            }
            this.sendClientEvent(endpoint);
        }
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.node.securityContext;
    }

    void bind(ClientEndpoint endpoint) {
        Connection conn = endpoint.getConnection();
        if (conn instanceof TcpIpConnection) {
            Address address = new Address(conn.getRemoteSocketAddress());
            TcpIpConnectionManager connectionManager = (TcpIpConnectionManager)this.node.getConnectionManager();
            connectionManager.bind((TcpIpConnection)conn, address, null, false);
        }
        this.sendClientEvent(endpoint);
    }

    void sendClientEvent(ClientEndpoint endpoint) {
        if (!endpoint.isFirstConnection()) {
            EventService eventService = this.nodeEngine.getEventService();
            Collection<EventRegistration> regs = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
            eventService.publishEvent(SERVICE_NAME, regs, (Object)endpoint, endpoint.getUuid().hashCode());
        }
    }

    @Override
    public void dispatchEvent(ClientEndpoint event, ClientListener listener) {
        if (event.isAuthenticated()) {
            listener.clientConnected(event);
        } else {
            listener.clientDisconnected(event);
        }
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        block3: {
            if (event.getMember().localMember()) {
                return;
            }
            final String uuid = event.getMember().getUuid();
            try {
                this.nodeEngine.getExecutionService().schedule(new Runnable(){

                    @Override
                    public void run() {
                        Iterator<ClientEndpoint> iterator = ClientEngineImpl.this.endpointManager.values().iterator();
                        while (iterator.hasNext()) {
                            ClientEndpoint endpoint = iterator.next();
                            String ownerUuid = endpoint.getPrincipal().getOwnerUuid();
                            if (!uuid.equals(ownerUuid)) continue;
                            iterator.remove();
                            ClientEngineImpl.this.destroyEndpoint(endpoint, true);
                        }
                    }
                }, 10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!this.logger.isFinestEnabled()) break block3;
                this.logger.finest(e);
            }
        }
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public Collection<Client> getClients() {
        HashSet<Client> clients = new HashSet<Client>();
        for (ClientEndpoint endpoint : this.endpointManager.values()) {
            if (endpoint.isFirstConnection()) continue;
            clients.add(endpoint);
        }
        return clients;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.node.getConnectionManager().addConnectionListener(this.connectionListener);
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        for (ClientEndpoint endpoint : this.endpointManager.values()) {
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.finest(e.getMessage());
            }
            try {
                Connection conn = endpoint.getConnection();
                if (!conn.live()) continue;
                conn.close();
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
        this.endpointManager.clear();
    }

    private final class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connectionAdded(Connection conn) {
        }

        @Override
        public void connectionRemoved(Connection connection) {
            if (connection.isClient() && connection instanceof TcpIpConnection && ClientEngineImpl.this.nodeEngine.isActive()) {
                String ownerUuid;
                ClientEndpoint endpoint = ClientEngineImpl.this.endpointManager.getEndpoint(connection);
                if (endpoint == null) {
                    return;
                }
                String localMemberUuid = ClientEngineImpl.this.node.getLocalMember().getUuid();
                if (localMemberUuid.equals(ownerUuid = endpoint.getPrincipal().getOwnerUuid())) {
                    this.doRemoveEndpoint(connection, endpoint);
                }
            }
        }

        private void doRemoveEndpoint(Connection connection, ClientEndpoint endpoint) {
            ClientEngineImpl.this.endpointManager.removeEndpoint(connection, true);
            if (!endpoint.isFirstConnection()) {
                return;
            }
            NodeEngineImpl nodeEngine = ((ClientEngineImpl)ClientEngineImpl.this).node.nodeEngine;
            Collection<MemberImpl> memberList = nodeEngine.getClusterService().getMemberList();
            OperationService operationService = nodeEngine.getOperationService();
            for (MemberImpl member : memberList) {
                ClientDisconnectionOperation op = new ClientDisconnectionOperation(endpoint.getUuid());
                op.setNodeEngine(nodeEngine).setServiceName(ClientEngineImpl.SERVICE_NAME).setService(ClientEngineImpl.this).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
                if (member.localMember()) {
                    operationService.runOperationOnCallingThread(op);
                    continue;
                }
                operationService.send(op, member.getAddress());
            }
        }
    }

    private final class ClientPacketProcessor
    implements Runnable {
        final ClientPacket packet;

        private ClientPacketProcessor(ClientPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            Connection conn = this.packet.getConn();
            ClientEndpoint endpoint = ClientEngineImpl.this.endpointManager.getEndpoint(conn);
            ClientRequest request = null;
            try {
                request = this.loadRequest();
                if (request == null) {
                    this.handlePacketWithNullRequest();
                } else if (request instanceof AuthenticationRequest) {
                    endpoint = ClientEngineImpl.this.endpointManager.createEndpoint(conn);
                    if (endpoint != null) {
                        this.processRequest(endpoint, request);
                    } else {
                        this.handleEndpointNotCreatedConnectionNotAlive();
                    }
                } else if (endpoint == null) {
                    this.handleMissingEndpoint(conn);
                } else if (endpoint.isAuthenticated()) {
                    this.processRequest(endpoint, request);
                } else {
                    this.handleAuthenticationFailure(conn, endpoint, request);
                }
            }
            catch (Throwable e) {
                this.handleProcessingFailure(endpoint, request, e);
            }
        }

        private ClientRequest loadRequest() {
            Data data = this.packet.getData();
            return (ClientRequest)ClientEngineImpl.this.serializationService.toObject(data);
        }

        private void handleEndpointNotCreatedConnectionNotAlive() {
            ClientEngineImpl.this.logger.warning("Dropped: " + this.packet + " -> endpoint not created for AuthenticationRequest, " + "connection not alive");
        }

        private void handlePacketWithNullRequest() {
            ClientEngineImpl.this.logger.warning("Dropped: " + this.packet + " -> null request");
        }

        private void handleMissingEndpoint(Connection conn) {
            if (conn.live()) {
                ClientEngineImpl.this.logger.severe("Dropping: " + this.packet + " -> no endpoint found for live connection.");
            } else if (ClientEngineImpl.this.logger.isFinestEnabled()) {
                ClientEngineImpl.this.logger.finest("Dropping: " + this.packet + " -> no endpoint found for dead connection.");
            }
        }

        private void handleProcessingFailure(ClientEndpoint endpoint, ClientRequest request, Throwable e) {
            Level level;
            Level level2 = level = ClientEngineImpl.this.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
            if (ClientEngineImpl.this.logger.isLoggable(level)) {
                if (request == null) {
                    ClientEngineImpl.this.logger.log(level, e.getMessage(), e);
                } else {
                    ClientEngineImpl.this.logger.log(level, "While executing request: " + request + " -> " + e.getMessage(), e);
                }
            }
            if (request != null && endpoint != null) {
                endpoint.sendResponse(e, request.getCallId());
            }
        }

        private void processRequest(ClientEndpoint endpoint, ClientRequest request) throws Exception {
            request.setEndpoint(endpoint);
            this.initService(request);
            request.setClientEngine(ClientEngineImpl.this);
            Credentials credentials = endpoint.getCredentials();
            this.interceptBefore(credentials, request);
            request.setSerializationService(ClientEngineImpl.this.serializationService);
            request.setOperationService(ClientEngineImpl.this.nodeEngine.getOperationService());
            this.checkPermissions(endpoint, request);
            request.process();
            this.interceptAfter(credentials, request);
        }

        private void interceptBefore(Credentials credentials, ClientRequest request) {
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            String methodName = request.getMethodName();
            if (securityContext != null && methodName != null) {
                String distributedObjectType = request.getDistributedObjectType();
                securityContext.interceptBefore(credentials, distributedObjectType, methodName, request.getParameters());
            }
        }

        private void interceptAfter(Credentials credentials, ClientRequest request) {
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            String methodName = request.getMethodName();
            if (securityContext != null && methodName != null) {
                String distributedObjectType = request.getDistributedObjectType();
                securityContext.interceptAfter(credentials, distributedObjectType, methodName);
            }
        }

        private void checkPermissions(ClientEndpoint endpoint, ClientRequest request) {
            Permission permission;
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            if (securityContext != null && (permission = request.getRequiredPermission()) != null) {
                securityContext.checkPermission(endpoint.getSubject(), permission);
            }
        }

        private void initService(ClientRequest request) {
            String serviceName = request.getServiceName();
            if (serviceName == null) {
                return;
            }
            Object service = ClientEngineImpl.this.nodeEngine.getService(serviceName);
            if (service == null) {
                if (ClientEngineImpl.this.nodeEngine.isActive()) {
                    throw new IllegalArgumentException("No service registered with name: " + serviceName);
                }
                throw new HazelcastInstanceNotActiveException();
            }
            request.setService(service);
        }

        private void handleAuthenticationFailure(Connection conn, ClientEndpoint endpoint, ClientRequest request) {
            RuntimeException exception;
            if (ClientEngineImpl.this.nodeEngine.isActive()) {
                String message = "Client " + conn + " must authenticate before any operation.";
                ClientEngineImpl.this.logger.severe(message);
                exception = new AuthenticationException(message);
            } else {
                exception = new HazelcastInstanceNotActiveException();
            }
            endpoint.sendResponse(exception, request.getCallId());
            ClientEngineImpl.this.endpointManager.removeEndpoint(conn);
        }
    }
}

