/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.SelectionHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import java.nio.channels.SelectionKey;

public abstract class ClientAbstractSelectionHandler
implements SelectionHandler,
Runnable {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final ClientConnection connection;
    protected final ClientConnectionManagerImpl connectionManager;
    protected final IOSelector ioSelector;
    private SelectionKey sk;

    public ClientAbstractSelectionHandler(ClientConnection connection, IOSelector ioSelector) {
        this.connection = connection;
        this.ioSelector = ioSelector;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    protected void shutdown() {
    }

    final void handleSocketException(Throwable e) {
        if (this.sk != null) {
            this.sk.cancel();
        }
        this.connection.close(e);
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append(" Closing socket to endpoint ");
        sb.append(this.connection.getEndPoint());
        sb.append(", Cause:").append(e);
        this.logger.warning(sb.toString());
    }

    final void registerOp(int operation) {
        try {
            if (!this.connection.live()) {
                return;
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.keyFor(this.ioSelector.getSelector());
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.register(this.ioSelector.getSelector(), operation, this);
            } else {
                this.sk.interestOps(this.sk.interestOps() | operation);
                if (this.sk.attachment() != this) {
                    this.sk.attach(this);
                }
            }
        }
        catch (Throwable e) {
            this.handleSocketException(e);
        }
    }

    public void register() {
        this.ioSelector.addTask(this);
        this.ioSelector.wakeup();
    }
}

