/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore.client;

import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.semaphore.client.SemaphorePortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;

public abstract class SemaphoreRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    protected String name;
    protected int permitCount;

    protected SemaphoreRequest() {
    }

    protected SemaphoreRequest(String name, int permitCount) {
        this.name = name;
        this.permitCount = permitCount;
    }

    @Override
    protected int getPartition() {
        ClientEngine clientEngine = this.getClientEngine();
        Data key = this.serializationService.toData(this.name);
        return clientEngine.getPartitionService().getPartitionId(key);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:semaphoreService";
    }

    @Override
    public int getFactoryId() {
        return SemaphorePortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("p", this.permitCount);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.permitCount = reader.readInt("p");
    }
}

