/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.tcp.DefaultSocketChannelWrapper;
import com.hazelcast.nio.tcp.PacketReader;
import com.hazelcast.nio.tcp.PacketWriter;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.storage.DataRef;
import com.hazelcast.storage.Storage;
import com.hazelcast.wan.WanReplicationService;
import com.hazelcast.wan.impl.WanReplicationServiceImpl;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class DefaultNodeInitializer
implements NodeInitializer {
    protected ILogger logger;
    protected ILogger systemLogger;
    protected Node node;
    protected String version;
    protected String build;

    @Override
    public void beforeInitialize(Node node) {
        this.node = node;
        this.systemLogger = node.getLogger("com.hazelcast.system");
        this.logger = node.getLogger("com.hazelcast.initializer");
        this.parseSystemProps();
    }

    @Override
    public void printNodeInfo(Node node) {
        this.systemLogger.info("Hazelcast " + this.version + " (" + this.build + ") starting at " + node.getThisAddress());
        this.systemLogger.info("Copyright (C) 2008-2014 Hazelcast.com");
    }

    @Override
    public void afterInitialize(Node node) {
    }

    protected void parseSystemProps() {
        this.version = this.node.getBuildInfo().getVersion();
        this.build = this.node.getBuildInfo().getBuild();
    }

    @Override
    public SecurityContext getSecurityContext() {
        this.logger.warning("Security features are only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public Storage<DataRef> getOffHeapStorage() {
        throw new UnsupportedOperationException("Offheap feature is only available on Hazelcast Enterprise!");
    }

    @Override
    public WanReplicationService geWanReplicationService() {
        return new WanReplicationServiceImpl(this.node);
    }

    @Override
    public MemberSocketInterceptor getMemberSocketInterceptor() {
        this.logger.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public SocketChannelWrapperFactory getSocketChannelWrapperFactory() {
        return new DefaultSocketChannelWrapperFactory();
    }

    @Override
    public PacketReader createPacketReader(TcpIpConnection connection, IOService ioService) {
        return new DefaultPacketReader(connection, ioService);
    }

    @Override
    public PacketWriter createPacketWriter(TcpIpConnection connection, IOService ioService) {
        return new DefaultPacketWriter();
    }

    @Override
    public void destroy() {
        this.logger.info("Destroying node initializer.");
    }

    public static class DefaultPacketWriter
    implements PacketWriter {
        @Override
        public boolean writePacket(Packet packet, ByteBuffer socketBB) {
            return packet.writeTo(socketBB);
        }
    }

    public class DefaultPacketReader
    implements PacketReader {
        protected final TcpIpConnection connection;
        protected final IOService ioService;
        protected Packet packet;

        protected DefaultPacketReader(TcpIpConnection connection, IOService ioService) {
            this.connection = connection;
            this.ioService = ioService;
        }

        @Override
        public void readPacket(ByteBuffer inBuffer) throws Exception {
            while (inBuffer.hasRemaining()) {
                boolean complete;
                if (this.packet == null) {
                    this.packet = this.obtainPacket();
                }
                if (!(complete = this.packet.readFrom(inBuffer))) break;
                this.packet.setConn(this.connection);
                this.ioService.handleMemberPacket(this.packet);
                this.packet = null;
            }
        }

        protected Packet obtainPacket() {
            PortableContext portableContext = DefaultNodeInitializer.this.node.getSerializationService().getPortableContext();
            return new Packet(portableContext);
        }
    }

    public static class DefaultSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new DefaultSocketChannelWrapper(socketChannel);
        }

        @Override
        public boolean isSSlEnabled() {
            return false;
        }
    }
}

